/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import it.unibz.inf.ontop.dbschema.QuotedID;
import java.io.IOException;
import javax.annotation.Nonnull;

public class QuotedIDImpl
implements QuotedID {
    private final String id;
    private final String quoteString;
    private final boolean caseSensitive;
    private final int hashCode;

    QuotedIDImpl(@Nonnull String id, String quoteString) {
        this(id, quoteString, true);
    }

    QuotedIDImpl(@Nonnull String id, String quoteString, boolean caseSensitive) {
        this.id = id;
        this.quoteString = quoteString;
        this.caseSensitive = caseSensitive;
        this.hashCode = id.toLowerCase().hashCode();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getSQLRendering() {
        return this.quoteString + this.id + this.quoteString;
    }

    public String toString() {
        return this.getSQLRendering();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuotedIDImpl) {
            QuotedIDImpl other = (QuotedIDImpl)obj;
            if (this.id.length() != other.id.length()) {
                return false;
            }
            return this.id.regionMatches(!this.caseSensitive || !other.caseSensitive, 0, other.id, 0, this.id.length());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class QuotedIDSerializer
    extends JsonSerializer<QuotedID> {
        public void serialize(QuotedID value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getSQLRendering());
        }
    }
}

