/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;

public class ImmutableMetadataImpl
implements ImmutableMetadata {
    private final DBParameters dbParameters;
    private final ImmutableList<NamedRelationDefinition> relations;

    ImmutableMetadataImpl(DBParameters dbParameters, ImmutableList<NamedRelationDefinition> relations) {
        this.dbParameters = dbParameters;
        this.relations = relations;
    }

    @Override
    public ImmutableList<NamedRelationDefinition> getAllRelations() {
        return this.relations;
    }

    @Override
    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        for (NamedRelationDefinition r : this.relations) {
            bf.append(r.getAllIDs()).append("=").append(r).append("\n");
        }
        bf.append("\n====== constraints ==========\n");
        for (NamedRelationDefinition r : this.relations) {
            for (UniqueConstraint uc : r.getUniqueConstraints()) {
                bf.append(uc).append(";\n");
            }
            bf.append("\n");
            for (ForeignKeyConstraint fk : r.getForeignKeys()) {
                bf.append(fk).append(";\n");
            }
            bf.append("\n");
        }
        return bf.toString();
    }
}

