/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.ImmutableMetadataImpl;
import it.unibz.inf.ontop.dbschema.impl.ImmutableMetadataLookup;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.HashMap;
import java.util.Map;

public class CachingMetadataLookup
implements MetadataLookup {
    private final MetadataProvider provider;
    private final Map<RelationID, NamedRelationDefinition> map = new HashMap<RelationID, NamedRelationDefinition>();

    public CachingMetadataLookup(MetadataProvider provider) {
        this.provider = provider;
    }

    @Override
    public NamedRelationDefinition getRelation(RelationID relationId) throws MetadataExtractionException {
        NamedRelationDefinition relation = this.map.get(relationId);
        if (relation != null) {
            return relation;
        }
        NamedRelationDefinition retrievedRelation = this.provider.getRelation(relationId);
        for (RelationID retrievedId : retrievedRelation.getAllIDs()) {
            NamedRelationDefinition prev = this.map.put(retrievedId, retrievedRelation);
            if (prev == null) continue;
            throw new MetadataExtractionException("Clashing relation IDs: " + retrievedId + " and " + relationId);
        }
        return retrievedRelation;
    }

    @Override
    public QuotedIDFactory getQuotedIDFactory() {
        return this.provider.getQuotedIDFactory();
    }

    public ImmutableMetadata extractImmutableMetadata() throws MetadataExtractionException {
        ImmutableMetadataLookup lookup = new ImmutableMetadataLookup(this.getQuotedIDFactory(), (ImmutableMap<RelationID, ? extends NamedRelationDefinition>)ImmutableMap.copyOf(this.map));
        ImmutableList<NamedRelationDefinition> list = lookup.getRelations();
        for (NamedRelationDefinition relation : list) {
            this.provider.insertIntegrityConstraints(relation, lookup);
        }
        return new ImmutableMetadataImpl(this.provider.getDBParameters(), list);
    }
}

