/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.constraints.impl.BasicLinearInclusionDependenciesImpl;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class DBLinearInclusionDependenciesImpl
extends BasicLinearInclusionDependenciesImpl<RelationPredicate> {
    private final AtomFactory atomFactory;
    private final VariableGenerator variableGenerator;

    public DBLinearInclusionDependenciesImpl(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory) {
        this.atomFactory = atomFactory;
        this.variableGenerator = coreUtilsFactory.createVariableGenerator((Collection<Variable>)ImmutableSet.of());
    }

    @Override
    protected Stream<DataAtom<RelationPredicate>> chase(DataAtom<RelationPredicate> atom) {
        return atom.getPredicate().getRelationDefinition().getForeignKeys().stream().map(fk -> this.chase((ForeignKeyConstraint)fk, atom)).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<DataAtom<RelationPredicate>> chase(ForeignKeyConstraint fk, DataAtom<RelationPredicate> atom) {
        if (fk.getComponents().stream().anyMatch(c -> c.getAttribute().isNullable())) {
            return Optional.empty();
        }
        ImmutableMap<Attribute, VariableOrGroundTerm> inversion = fk.getComponents().stream().collect(ImmutableCollectors.toMap(ForeignKeyConstraint.Component::getReferencedAttribute, c -> (VariableOrGroundTerm)atom.getArguments().get(c.getAttribute().getIndex() - 1)));
        ImmutableList newArguments = (ImmutableList)fk.getReferencedRelation().getAttributes().stream().map(a -> (VariableOrGroundTerm)inversion.getOrDefault(a, (Object)this.variableGenerator.generateNewVariable(a.getID().getName()))).collect(ImmutableCollectors.toList());
        return Optional.of(this.atomFactory.getDataAtom(fk.getReferencedRelation().getAtomPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)newArguments));
    }

    @Override
    protected void registerVariables(DataAtom<RelationPredicate> atom) {
        this.variableGenerator.registerAdditionalVariables((Collection<Variable>)atom.getVariables());
    }

    public String toString() {
        return "DB LIDs";
    }
}

