/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class UnifierUtilities {
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    public UnifierUtilities(TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public <T extends ImmutableTerm> Optional<ImmutableSubstitution<T>> getMGU(ImmutableList<? extends ImmutableTerm> args1, ImmutableList<? extends ImmutableTerm> args2) {
        if (args1.equals(args2)) {
            return Optional.of(this.substitutionFactory.getSubstitution());
        }
        ImmutableMap<Variable, ImmutableTerm> sub = this.unify((ImmutableMap<Variable, ImmutableTerm>)ImmutableMap.of(), args1, args2);
        if (sub == null) {
            return Optional.empty();
        }
        return Optional.of(this.substitutionFactory.getSubstitution(sub));
    }

    private static boolean variableOccursInTerm(Variable v, ImmutableTerm term) {
        if (term instanceof ImmutableFunctionalTerm) {
            return ((ImmutableFunctionalTerm)term).getTerms().stream().anyMatch(t -> UnifierUtilities.variableOccursInTerm(v, t));
        }
        return v.equals(term);
    }

    private ImmutableTerm apply(ImmutableTerm t, ImmutableMap<Variable, ImmutableTerm> sub) {
        if (t instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)t;
            ImmutableList terms = (ImmutableList)f.getTerms().stream().map(tt -> this.apply((ImmutableTerm)tt, sub)).collect(ImmutableCollectors.toList());
            return this.termFactory.getImmutableFunctionalTerm(f.getFunctionSymbol(), (ImmutableList<? extends ImmutableTerm>)terms);
        }
        return (ImmutableTerm)sub.getOrDefault((Object)t, (Object)t);
    }

    private ImmutableMap<Variable, ImmutableTerm> unify(ImmutableMap<Variable, ImmutableTerm> sub, ImmutableList<? extends ImmutableTerm> args1, ImmutableList<? extends ImmutableTerm> args2) {
        if (args1.size() != args2.size()) {
            return null;
        }
        int arity = args1.size();
        for (int i = 0; i < arity; ++i) {
            ImmutableMap s;
            ImmutableTerm term2;
            ImmutableTerm term1 = this.apply((ImmutableTerm)args1.get(i), (ImmutableMap<Variable, ImmutableTerm>)sub);
            if (term1.equals(term2 = this.apply((ImmutableTerm)args2.get(i), (ImmutableMap<Variable, ImmutableTerm>)sub))) continue;
            if (term1 instanceof ImmutableFunctionalTerm && term2 instanceof ImmutableFunctionalTerm) {
                ImmutableFunctionalTerm f1 = (ImmutableFunctionalTerm)term1;
                ImmutableFunctionalTerm f2 = (ImmutableFunctionalTerm)term2;
                if (!f1.getFunctionSymbol().equals(f2.getFunctionSymbol())) {
                    return null;
                }
                if ((sub = this.unify((ImmutableMap<Variable, ImmutableTerm>)sub, f1.getTerms(), f2.getTerms())) != null) continue;
                return null;
            }
            if (term1 instanceof Variable && !UnifierUtilities.variableOccursInTerm((Variable)term1, term2)) {
                s = ImmutableMap.of((Object)((Variable)term1), (Object)term2);
            } else if (term2 instanceof Variable && !UnifierUtilities.variableOccursInTerm((Variable)term2, term1)) {
                s = ImmutableMap.of((Object)((Variable)term2), (Object)term1);
            } else {
                return null;
            }
            sub = Stream.concat(s.entrySet().stream(), sub.entrySet().stream().map(e -> Maps.immutableEntry(e.getKey(), (Object)this.apply((ImmutableTerm)e.getValue(), (ImmutableMap<Variable, ImmutableTerm>)s))).filter(e -> !((ImmutableTerm)e.getValue()).equals(e.getKey()))).collect(ImmutableCollectors.toMap());
        }
        return sub;
    }
}

