/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.Var2VarSubstitutionImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class InjectiveVar2VarSubstitutionImpl
extends Var2VarSubstitutionImpl
implements InjectiveVar2VarSubstitution {
    private final boolean isEmpty;

    protected InjectiveVar2VarSubstitutionImpl(Map<Variable, Variable> substitutionMap, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(substitutionMap, atomFactory, termFactory, substitutionFactory);
        this.isEmpty = substitutionMap.isEmpty();
        if (!this.isEmpty && !InjectiveVar2VarSubstitutionImpl.isInjective(substitutionMap)) {
            throw new IllegalArgumentException("Non-injective map given: " + substitutionMap);
        }
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> applyRenaming(ImmutableSubstitution<T> substitutionToRename) {
        if (this.isEmpty) {
            return substitutionToRename;
        }
        ImmutableMap.Builder substitutionMapBuilder = ImmutableMap.builder();
        for (Map.Entry originalEntry : substitutionToRename.getImmutableMap().entrySet()) {
            Variable convertedVariable = this.applyToVariable((Variable)originalEntry.getKey());
            ImmutableTerm convertedTargetTerm = this.applyToTerm((ImmutableTerm)originalEntry.getValue());
            if (convertedTargetTerm.equals(convertedVariable)) continue;
            substitutionMapBuilder.put((Object)convertedVariable, (Object)convertedTargetTerm);
        }
        return this.substitutionFactory.getSubstitution(substitutionMapBuilder.build());
    }

    @Override
    public Optional<InjectiveVar2VarSubstitution> composeWithAndPreserveInjectivity(InjectiveVar2VarSubstitution g, Set<Variable> variablesToExcludeFromTheDomain) {
        ImmutableMap newMap = this.composeRenaming(g).filter(e -> !variablesToExcludeFromTheDomain.contains(e.getKey())).collect(ImmutableCollectors.toMap());
        return Optional.of(newMap).filter(InjectiveVar2VarSubstitutionImpl::isInjective).map(this.substitutionFactory::getInjectiveVar2VarSubstitution);
    }

    @Override
    public InjectiveVar2VarSubstitution reduceDomainToIntersectionWith(ImmutableSet<Variable> restrictingDomain) {
        if (restrictingDomain.containsAll(this.getDomain())) {
            return this;
        }
        return this.substitutionFactory.getInjectiveVar2VarSubstitution((Map)this.getImmutableMap().entrySet().stream().filter(e -> restrictingDomain.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
    }

    @Override
    public <T extends ImmutableTerm> Optional<ImmutableSubstitution<T>> applyToSubstitution(ImmutableSubstitution<T> substitution) {
        return Optional.of(this.applyRenaming(substitution));
    }

    private static boolean isInjective(Map<Variable, ? extends VariableOrGroundTerm> substitutionMap) {
        ImmutableSet valueSet = ImmutableSet.copyOf(substitutionMap.values());
        return valueSet.size() == substitutionMap.keySet().size();
    }
}

