/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class RDFTermTypeFunctionSymbolImpl
extends FunctionSymbolImpl
implements RDFTermTypeFunctionSymbol {
    private final MetaRDFTermType metaType;
    private final TypeConstantDictionary dictionary;
    private final ImmutableBiMap<DBConstant, RDFTermTypeConstant> conversionMap;
    private final boolean isSimplifiable;
    private final RDFTermTypeFunctionSymbol simplifiableVariant;

    protected RDFTermTypeFunctionSymbolImpl(TypeFactory typeFactory, TypeConstantDictionary dictionary, ImmutableBiMap<DBConstant, RDFTermTypeConstant> conversionMap, boolean isSimplifiable) {
        super("RDF_TYPE" + RDFTermTypeFunctionSymbolImpl.extractConversionMapString(conversionMap), (ImmutableList<TermType>)ImmutableList.of((Object)typeFactory.getDBTypeFactory().getDBLargeIntegerType()));
        this.metaType = typeFactory.getMetaRDFTermType();
        this.dictionary = dictionary;
        this.conversionMap = conversionMap;
        this.isSimplifiable = isSimplifiable;
        this.simplifiableVariant = isSimplifiable ? this : new RDFTermTypeFunctionSymbolImpl(typeFactory, dictionary, conversionMap, true);
    }

    private static String extractConversionMapString(ImmutableBiMap<DBConstant, RDFTermTypeConstant> conversionMap) {
        return conversionMap.entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((DBConstant)e.getKey()).getValue(), Map.Entry::getValue)).toString().replace(" ", "");
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return true;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.metaType));
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm term = (ImmutableTerm)newTerms.get(0);
        if (this.isSimplifiable && term instanceof DBConstant) {
            return (ImmutableTerm)this.conversionMap.get((Object)term);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, term);
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return this.isSimplifiable;
    }

    @Override
    public ImmutableBiMap<DBConstant, RDFTermTypeConstant> getConversionMap() {
        return this.conversionMap;
    }

    @Override
    public TypeConstantDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public ImmutableFunctionalTerm lift(ImmutableList<? extends ImmutableTerm> terms, Function<RDFTermTypeConstant, ImmutableTerm> caseTermFct, TermFactory termFactory) {
        return termFactory.getDBCase(this.computeWhenPairs(terms, caseTermFct, termFactory), termFactory.getNullConstant(), false);
    }

    private <T extends ImmutableTerm> Stream<Map.Entry<ImmutableExpression, T>> computeWhenPairs(ImmutableList<? extends ImmutableTerm> terms, Function<RDFTermTypeConstant, T> caseTermFct, TermFactory termFactory) {
        ImmutableTerm term = (ImmutableTerm)terms.get(0);
        return this.conversionMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)termFactory.getStrictEquality(term, (ImmutableTerm)e.getKey(), new ImmutableTerm[0]), caseTermFct.apply((RDFTermTypeConstant)e.getValue())));
    }

    @Override
    public ImmutableExpression liftExpression(ImmutableList<? extends ImmutableTerm> terms, Function<RDFTermTypeConstant, ImmutableExpression> caseExpressionFct, TermFactory termFactory) {
        return termFactory.getDBBooleanCase(this.computeWhenPairs(terms, caseExpressionFct, termFactory), termFactory.getIsTrue(termFactory.getNullConstant()), false);
    }

    @Override
    public RDFTermTypeFunctionSymbol getSimplifiableVariant() {
        return this.simplifiableVariant;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        if (!(otherTerm instanceof RDFTermTypeConstant)) {
            throw new MinorOntopInternalBugException("Was expecting the constant to be a RDFTermTypeConstant: " + otherTerm);
        }
        RDFTermTypeConstant typeConstant = (RDFTermTypeConstant)otherTerm;
        return Optional.ofNullable(this.conversionMap.inverse().get((Object)typeConstant)).map(c -> termFactory.getStrictEquality((ImmutableTerm)terms.get(0), (ImmutableTerm)c, new ImmutableTerm[0])).map(IncrementalEvaluation::declareSimplifiedExpression).orElseGet(IncrementalEvaluation::declareIsFalse);
    }

    @Override
    protected boolean tolerateNulls() {
        return !this.isSimplifiable;
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getDBIsNotNull((ImmutableTerm)terms.get(0)).evaluate(variableNullability, true);
    }
}

