/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBCaseFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DBBooleanCaseFunctionSymbolImpl
extends DefaultDBCaseFunctionSymbol
implements DBBooleanFunctionSymbol {
    protected DBBooleanCaseFunctionSymbolImpl(int arity, DBTermType dbBooleanType, DBTermType rootDBTermType, boolean doOrderingMatter) {
        super("BOOL_CASE" + arity + (doOrderingMatter ? "" : "_UNORDERED"), arity, dbBooleanType, rootDBTermType, doOrderingMatter);
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ImmutableExpression simplifyValue(ImmutableTerm immutableTerm, VariableNullability variableNullability, TermFactory termFactory) {
        ImmutableTerm simplifiedTerm = immutableTerm.simplify(variableNullability);
        return simplifiedTerm instanceof ImmutableExpression ? (ImmutableExpression)simplifiedTerm : termFactory.getIsTrue((NonFunctionalTerm)simplifiedTerm);
    }

    @Override
    protected ImmutableFunctionalTerm buildCase(Stream<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> newWhenPairs, ImmutableTerm defaultValue, TermFactory termFactory) {
        return termFactory.getDBBooleanCase(newWhenPairs, (ImmutableExpression)defaultValue, this.doOrderingMatter);
    }

    @Override
    public ImmutableTerm simplify2VL(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableExpression newExpression;
        if (!terms.stream().allMatch(t -> t instanceof ImmutableExpression)) {
            throw new MinorOntopInternalBugException("Was expecting all its arguments to be ImmutableExpression-s");
        }
        ImmutableList twoVLExpressions = (ImmutableList)terms.stream().map(t -> (ImmutableExpression)t).map(t -> t.simplify2VL(variableNullability)).map(t -> t instanceof ImmutableExpression ? (ImmutableExpression)t : termFactory.getIsTrue((NonFunctionalTerm)t)).collect(ImmutableCollectors.toList());
        Optional<ImmutableExpression> optionalSimplification = this.tryToReduceToDisjunctionOrConjunction((ImmutableList<ImmutableExpression>)twoVLExpressions, variableNullability, termFactory);
        if (optionalSimplification.isPresent()) {
            return optionalSimplification.get().simplify2VL(variableNullability);
        }
        ImmutableTerm newTerm = this.simplify((ImmutableList<? extends ImmutableTerm>)twoVLExpressions, termFactory, variableNullability);
        if (!(!(newTerm instanceof ImmutableExpression) || this.equals((newExpression = (ImmutableExpression)newTerm).getFunctionSymbol()) && terms.equals(newExpression.getTerms()))) {
            return newExpression.simplify2VL(variableNullability);
        }
        if (newTerm.isNull()) {
            return termFactory.getDBBooleanConstant(false);
        }
        return newTerm;
    }

    private Optional<ImmutableExpression> tryToReduceToDisjunctionOrConjunction(ImmutableList<ImmutableExpression> twoVLExpressions, VariableNullability variableNullability, TermFactory termFactory) {
        if (!this.doOrderingMatter) {
            ImmutableTerm defaultValue = this.extractDefaultValue(twoVLExpressions, termFactory);
            ImmutableExpression falseExpression = termFactory.getIsTrue(termFactory.getDBBooleanConstant(false));
            ImmutableExpression trueExpression = termFactory.getIsTrue(termFactory.getDBBooleanConstant(true));
            if (defaultValue.equals(falseExpression) || defaultValue.equals(trueExpression)) {
                boolean isFalseByDefault = defaultValue.equals(falseExpression);
                ImmutableExpression oppositeExpression = isFalseByDefault ? trueExpression : falseExpression;
                if (IntStream.range(0, twoVLExpressions.size() - 1).filter(i -> i % 2 == 1).boxed().map(arg_0 -> twoVLExpressions.get(arg_0)).allMatch(e -> e.equals(oppositeExpression))) {
                    ImmutableSet conditions = (ImmutableSet)IntStream.range(0, twoVLExpressions.size()).filter(i -> i % 2 == 0).boxed().map(arg_0 -> twoVLExpressions.get(arg_0)).collect(ImmutableCollectors.toSet());
                    if (isFalseByDefault || conditions.stream().noneMatch(c -> c.isNullable(variableNullability.getNullableVariables()))) {
                        Stream<ImmutableExpression> newConditionStream = conditions.stream().map(c -> isFalseByDefault ? c : termFactory.getDBNot((ImmutableExpression)c));
                        return isFalseByDefault ? termFactory.getDisjunction(newConditionStream) : termFactory.getConjunction(newConditionStream);
                    }
                }
            }
        }
        return Optional.empty();
    }
}

