/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeTools;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class UnionNodeImpl
extends CompositeQueryNodeImpl
implements UnionNode {
    private static final String UNION_NODE_STR = "UNION";
    private final ImmutableSet<Variable> projectedVariables;
    private final ConstructionNodeTools constructionTools;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final ConstructionSubstitutionNormalizer substitutionNormalizer;
    private final NotRequiredVariableRemover notRequiredVariableRemover;

    @AssistedInject
    private UnionNodeImpl(@Assisted ImmutableSet<Variable> projectedVariables, ConstructionNodeTools constructionTools, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory, CoreUtilsFactory coreUtilsFactory, ConstructionSubstitutionNormalizer substitutionNormalizer, NotRequiredVariableRemover notRequiredVariableRemover) {
        super(substitutionFactory, iqFactory);
        this.projectedVariables = projectedVariables;
        this.constructionTools = constructionTools;
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.substitutionNormalizer = substitutionNormalizer;
        this.notRequiredVariableRemover = notRequiredVariableRemover;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public UnionNode clone() {
        return new UnionNodeImpl(this.projectedVariables, this.constructionTools, this.iqFactory, this.substitutionFactory, this.termFactory, this.coreUtilsFactory, this.substitutionNormalizer, this.notRequiredVariableRemover);
    }

    @Override
    public UnionNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions(ImmutableList<IQTree> children) {
        return (ImmutableSet)children.stream().flatMap(c -> c.getPossibleVariableDefinitions().stream()).map(s -> s.reduceDomainToIntersectionWith(this.projectedVariables)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean hasAChildWithLiftableDefinition(Variable variable, ImmutableList<IQTree> children) {
        return children.stream().anyMatch(c -> c.getRootNode() instanceof ConstructionNode && ((ConstructionNode)c.getRootNode()).getSubstitution().isDefining(variable));
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        for (QueryNode child : query.getChildren(this)) {
            if (!child.isVariableNullable(query, variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VariableNullability getVariableNullability(ImmutableList<IQTree> children) {
        ImmutableSet variableNullabilities = (ImmutableSet)children.stream().map(IQTree::getVariableNullability).collect(ImmutableCollectors.toSet());
        ImmutableMultimap multimap = variableNullabilities.stream().flatMap(vn -> vn.getNullableGroups().stream()).flatMap(g -> g.stream().map(v -> Maps.immutableEntry((Object)v, (Object)g))).collect(ImmutableCollectors.toMultimap());
        ImmutableMap<Variable, ImmutableSet> preselectedGroupMap = multimap.asMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> UnionNodeImpl.intersect((Collection)e.getValue())));
        ImmutableSet nullableGroups = (ImmutableSet)preselectedGroupMap.keySet().stream().map(v -> this.computeNullableGroup((Variable)v, (ImmutableMap<Variable, ImmutableSet<Variable>>)preselectedGroupMap, (ImmutableSet<VariableNullability>)variableNullabilities)).collect(ImmutableCollectors.toSet());
        ImmutableSet scope = (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, (ImmutableSet<Variable>)scope);
    }

    private ImmutableSet<Variable> computeNullableGroup(Variable mainVariable, ImmutableMap<Variable, ImmutableSet<Variable>> preselectedGroupMap, ImmutableSet<VariableNullability> variableNullabilities) {
        return (ImmutableSet)((ImmutableSet)preselectedGroupMap.get((Object)mainVariable)).stream().filter(v -> mainVariable.equals(v) || this.areInterdependent(mainVariable, (Variable)v, preselectedGroupMap, variableNullabilities)).collect(ImmutableCollectors.toSet());
    }

    private boolean areInterdependent(Variable v1, Variable v2, ImmutableMap<Variable, ImmutableSet<Variable>> preselectedGroupMap, ImmutableSet<VariableNullability> variableNullabilities) {
        return ((ImmutableSet)preselectedGroupMap.get((Object)v2)).contains((Object)v1) && variableNullabilities.stream().allMatch(vn -> {
            boolean v1Nullable = vn.isPossiblyNullable(v1);
            boolean v2Nullable = vn.isPossiblyNullable(v2);
            return v1Nullable && v2Nullable || !v1Nullable && !v2Nullable;
        });
    }

    private static ImmutableSet<Variable> intersect(Collection<ImmutableSet<Variable>> groups) {
        return groups.stream().reduce((g1, g2) -> Sets.intersection((Set)g1, (Set)g2).immutableCopy()).orElseThrow(() -> new IllegalArgumentException("groups must not be empty"));
    }

    @Override
    public boolean isConstructed(Variable variable, ImmutableList<IQTree> children) {
        return children.stream().anyMatch(c -> c.isConstructed(variable));
    }

    @Override
    public boolean isDistinct(IQTree tree, ImmutableList<IQTree> children) {
        if (children.stream().anyMatch(c -> !c.isDistinct())) {
            return false;
        }
        return IntStream.range(0, children.size()).allMatch(i -> children.subList(i + 1, children.size()).stream().allMatch(o -> this.areDisjoint((IQTree)children.get(i), (IQTree)o)));
    }

    private boolean areDisjoint(IQTree child1, IQTree child2) {
        VariableNullability variableNullability1 = child1.getVariableNullability();
        VariableNullability variableNullability2 = child2.getVariableNullability();
        ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleDefs1 = child1.getPossibleVariableDefinitions();
        ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleDefs2 = child2.getPossibleVariableDefinitions();
        return this.projectedVariables.stream().filter(v -> !variableNullability1.isPossiblyNullable((Variable)v) || !variableNullability2.isPossiblyNullable((Variable)v)).anyMatch(v -> this.areDisjointWhenNonNull(UnionNodeImpl.extractDefs(possibleDefs1, v), UnionNodeImpl.extractDefs(possibleDefs2, v), variableNullability1));
    }

    @Override
    public IQTree makeDistinct(ImmutableList<IQTree> children) {
        ImmutableMap<IQTree, ImmutableSet<IQTree>> compatibilityMap = this.extractCompatibilityMap(children);
        if (this.areGroupDisjoint(compatibilityMap)) {
            return this.makeDistinctDisjointGroups((ImmutableSet<ImmutableSet<IQTree>>)ImmutableSet.copyOf((Collection)compatibilityMap.values()));
        }
        return this.makeDistinctGroup((ImmutableSet<IQTree>)ImmutableSet.copyOf(children));
    }

    private ImmutableMap<IQTree, ImmutableSet<IQTree>> extractCompatibilityMap(ImmutableList<IQTree> children) {
        return IntStream.range(0, children.size()).boxed().flatMap(i -> IntStream.range(i, children.size()).boxed().flatMap(j -> i.equals(j) || !this.areDisjoint((IQTree)children.get(i.intValue()), (IQTree)children.get(j.intValue())) ? Stream.of(Maps.immutableEntry((Object)children.get(i.intValue()), (Object)children.get(j.intValue())), Maps.immutableEntry((Object)children.get(j.intValue()), (Object)children.get(i.intValue()))) : Stream.empty())).collect(ImmutableCollectors.toMultimap()).asMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue()))));
    }

    private IQTree makeDistinctDisjointGroups(ImmutableSet<ImmutableSet<IQTree>> disjointGroups) {
        ImmutableList newChildren = (ImmutableList)disjointGroups.stream().map(this::makeDistinctGroup).collect(ImmutableCollectors.toList());
        switch (newChildren.size()) {
            case 0: {
                throw new MinorOntopInternalBugException("Was expecting to have at least one group of Union children");
            }
            case 1: {
                return (IQTree)newChildren.get(0);
            }
        }
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)newChildren);
    }

    private IQTree makeDistinctGroup(ImmutableSet<IQTree> childGroup) {
        switch (childGroup.size()) {
            case 0: {
                throw new MinorOntopInternalBugException("Unexpected empty child group");
            }
            case 1: {
                return this.iqFactory.createUnaryIQTree(this.iqFactory.createDistinctNode(), (IQTree)childGroup.iterator().next());
            }
        }
        return this.iqFactory.createUnaryIQTree(this.iqFactory.createDistinctNode(), this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)ImmutableList.copyOf(childGroup)));
    }

    private boolean areGroupDisjoint(ImmutableMap<IQTree, ImmutableSet<IQTree>> compatibilityMap) {
        return compatibilityMap.values().stream().allMatch(g -> g.stream().allMatch(t -> ((ImmutableSet)compatibilityMap.get(t)).equals(g)));
    }

    private static ImmutableSet<ImmutableTerm> extractDefs(ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleDefs, Variable v) {
        if (possibleDefs.isEmpty()) {
            return ImmutableSet.of((Object)v);
        }
        return (ImmutableSet)possibleDefs.stream().map(s -> s.apply(v)).collect(ImmutableCollectors.toSet());
    }

    private boolean areDisjointWhenNonNull(ImmutableSet<ImmutableTerm> defs1, ImmutableSet<ImmutableTerm> defs2, VariableNullability variableNullability) {
        return defs1.stream().allMatch(d1 -> defs2.stream().allMatch(d2 -> this.areDisjointWhenNonNull((ImmutableTerm)d1, (ImmutableTerm)d2, variableNullability)));
    }

    private boolean areDisjointWhenNonNull(ImmutableTerm t1, ImmutableTerm t2, VariableNullability variableNullability) {
        IncrementalEvaluation evaluation = t1.evaluateStrictEq(t2, variableNullability);
        switch (evaluation.getStatus()) {
            case SIMPLIFIED_EXPRESSION: {
                return evaluation.getNewExpression().orElseThrow(() -> new MinorOntopInternalBugException("An expression was expected")).evaluate2VL(variableNullability).isEffectiveFalse();
            }
            case IS_NULL: 
            case IS_FALSE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        ImmutableList liftedChildren = (ImmutableList)children.stream().map(c -> c.liftIncompatibleDefinitions(variable, variableGenerator)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)liftedChildren);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, ImmutableList<IQTree> children) {
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)((ImmutableList)children.stream().map(c -> c.propagateDownConstraint(constraint)).collect(ImmutableCollectors.toList())));
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, ImmutableList<IQTree> children) {
        return transformer.transformUnion(tree, this, children);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, ImmutableList<IQTree> children) {
        return visitor.visitUnion(this, children);
    }

    @Override
    public void validateNode(ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        if (children.size() < 2) {
            throw new InvalidIntermediateQueryException("UNION node " + this + " does not have at least 2 children node.");
        }
        ImmutableSet<Variable> unionVariables = this.getVariables();
        for (IQTree child : children) {
            if (child.getVariables().containsAll(unionVariables)) continue;
            throw new InvalidIntermediateQueryException("This child " + child + " does not project all the variables required by the UNION node (" + unionVariables + ")\n" + this);
        }
    }

    @Override
    public IQTree removeDistincts(ImmutableList<IQTree> children, IQProperties properties) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(IQTree::removeDistincts).collect(ImmutableCollectors.toList());
        IQProperties newProperties = newChildren.equals(children) ? properties.declareDistinctRemovalWithoutEffect() : properties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this, children, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(ImmutableList<IQTree> children) {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(ImmutableList<IQTree> children) {
        return this.getVariables();
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        if (node instanceof UnionNode) {
            return this.projectedVariables.equals(((UnionNode)node).getVariables());
        }
        return false;
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return this.projectedVariables;
    }

    public String toString() {
        return "UNION " + this.projectedVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.projectedVariables;
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return this.getLocallyRequiredVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        if (!(queryNode instanceof UnionNode)) {
            return false;
        }
        return this.projectedVariables.equals(((UnionNode)queryNode).getVariables());
    }

    @Override
    public IQTree normalizeForOptimization(ImmutableList<IQTree> children, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        ImmutableList liftedChildren = (ImmutableList)children.stream().map(c -> c.normalizeForOptimization(variableGenerator)).filter(c -> !c.isDeclaredAsEmpty()).map(c -> this.notRequiredVariableRemover.optimize((IQTree)c, this.projectedVariables, variableGenerator)).collect(ImmutableCollectors.toList());
        switch (liftedChildren.size()) {
            case 0: {
                return this.iqFactory.createEmptyNode(this.projectedVariables);
            }
            case 1: {
                return (IQTree)liftedChildren.get(0);
            }
        }
        return this.liftBindingFromLiftedChildrenAndFlatten((ImmutableList<IQTree>)liftedChildren, variableGenerator, currentIQProperties);
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, ImmutableList<IQTree> children) {
        ImmutableSet<Variable> updatedProjectedVariables = this.constructionTools.computeNewProjectedVariables(descendingSubstitution, this.projectedVariables);
        ImmutableList updatedChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitution(descendingSubstitution, constraint)).filter(c -> !c.isDeclaredAsEmpty()).collect(ImmutableCollectors.toList());
        switch (updatedChildren.size()) {
            case 0: {
                return this.iqFactory.createEmptyNode(updatedProjectedVariables);
            }
            case 1: {
                return (IQTree)updatedChildren.get(0);
            }
        }
        UnionNode newRootNode = this.iqFactory.createUnionNode(updatedProjectedVariables);
        return this.iqFactory.createNaryIQTree(newRootNode, (ImmutableList<IQTree>)updatedChildren);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableList<IQTree> children) {
        ImmutableSet<Variable> updatedProjectedVariables = this.constructionTools.computeNewProjectedVariables(descendingSubstitution, this.projectedVariables);
        ImmutableList updatedChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution)).collect(ImmutableCollectors.toList());
        UnionNode newRootNode = this.iqFactory.createUnionNode(updatedProjectedVariables);
        return this.iqFactory.createNaryIQTree(newRootNode, (ImmutableList<IQTree>)updatedChildren);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, ImmutableList<IQTree> children, IQTreeCache treeCache) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyFreshRenaming(renamingSubstitution)).collect(ImmutableCollectors.toList());
        UnionNode newUnionNode = this.iqFactory.createUnionNode((ImmutableSet<Variable>)((ImmutableSet)this.getVariables().stream().map(renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet())));
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)newUnionNode, (ImmutableList<IQTree>)newChildren, newTreeCache);
    }

    private IQTree liftBindingFromLiftedChildrenAndFlatten(ImmutableList<IQTree> liftedChildren, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        if (liftedChildren.stream().anyMatch(c -> !(c.getRootNode() instanceof ConstructionNode))) {
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)this, this.flattenChildren(liftedChildren), currentIQProperties.declareNormalizedForOptimization());
        }
        ImmutableList tmpNormalizedChildSubstitutions = (ImmutableList)liftedChildren.stream().map(c -> (ConstructionNode)c.getRootNode()).map(ConstructionNode::getSubstitution).map(this::tmpNormalizeNullAndRDFConstantsInSubstitution).collect(ImmutableCollectors.toList());
        ImmutableSubstitution<ImmutableTerm> mergedSubstitution = this.mergeChildSubstitutions(this.projectedVariables, (ImmutableCollection<ImmutableSubstitution<ImmutableTerm>>)tmpNormalizedChildSubstitutions, variableGenerator);
        if (mergedSubstitution.isEmpty()) {
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)this, this.flattenChildren(liftedChildren), currentIQProperties.declareNormalizedForOptimization());
        }
        ConstructionNode newRootNode = this.iqFactory.createConstructionNode(this.projectedVariables, mergedSubstitution.simplifyValues());
        ImmutableSet<Variable> unionVariables = newRootNode.getChildVariables();
        UnionNode newUnionNode = this.iqFactory.createUnionNode(unionVariables);
        NaryIQTree unionIQ = this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)((ImmutableList)IntStream.range(0, liftedChildren.size()).boxed().map(i -> this.updateChild((UnaryIQTree)liftedChildren.get(i.intValue()), mergedSubstitution, (ImmutableSubstitution)tmpNormalizedChildSubstitutions.get(i.intValue()), unionVariables)).flatMap(this::flattenChild).collect(ImmutableCollectors.toList())));
        return this.iqFactory.createUnaryIQTree(newRootNode, unionIQ);
    }

    private ImmutableList<IQTree> flattenChildren(ImmutableList<IQTree> liftedChildren) {
        ImmutableList flattenedChildren = (ImmutableList)liftedChildren.stream().flatMap(this::flattenChild).collect(ImmutableCollectors.toList());
        return liftedChildren.size() == flattenedChildren.size() ? liftedChildren : flattenedChildren;
    }

    private Stream<IQTree> flattenChild(IQTree child) {
        return child.getRootNode() instanceof UnionNode ? child.getChildren().stream() : Stream.of(child);
    }

    private ImmutableSubstitution<ImmutableTerm> tmpNormalizeNullAndRDFConstantsInSubstitution(ImmutableSubstitution<ImmutableTerm> substitution) {
        return this.substitutionFactory.getSubstitution(substitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.normalizeNullAndRDFConstants((ImmutableTerm)e.getValue()))));
    }

    private ImmutableTerm normalizeNullAndRDFConstants(ImmutableTerm definition) {
        if (definition instanceof RDFConstant) {
            RDFConstant constant = (RDFConstant)definition;
            return this.termFactory.getRDFFunctionalTerm(this.termFactory.getDBStringConstant(constant.getValue()), this.termFactory.getRDFTermTypeConstant(constant.getType()));
        }
        if (definition instanceof Constant && definition.isNull()) {
            return this.termFactory.getRDFFunctionalTerm(this.termFactory.getNullConstant(), this.termFactory.getNullConstant());
        }
        return definition;
    }

    private ImmutableSubstitution<ImmutableTerm> mergeChildSubstitutions(ImmutableSet<Variable> projectedVariables, ImmutableCollection<ImmutableSubstitution<ImmutableTerm>> childSubstitutions, VariableGenerator variableGenerator) {
        ImmutableMap substitutionMap = projectedVariables.stream().flatMap(v -> this.mergeDefinitions((Variable)v, childSubstitutions, variableGenerator).map(d -> Stream.of(new AbstractMap.SimpleEntry<Variable, ImmutableTerm>((Variable)v, (ImmutableTerm)d))).orElseGet(Stream::empty)).collect(ImmutableCollectors.toMap());
        return this.substitutionFactory.getSubstitution(substitutionMap);
    }

    private Optional<ImmutableTerm> mergeDefinitions(Variable variable, ImmutableCollection<ImmutableSubstitution<ImmutableTerm>> childSubstitutions, VariableGenerator variableGenerator) {
        if (childSubstitutions.stream().anyMatch(s -> !s.isDefining(variable))) {
            return Optional.empty();
        }
        return childSubstitutions.stream().map(s -> s.get(variable)).map(this::normalizeNullAndRDFConstants).map(Optional::of).reduce((od1, od2) -> od1.flatMap(d1 -> od2.flatMap(d2 -> this.combineDefinitions((ImmutableTerm)d1, (ImmutableTerm)d2, variableGenerator, true)))).flatMap(t -> t);
    }

    private Optional<ImmutableTerm> combineDefinitions(ImmutableTerm d1, ImmutableTerm d2, VariableGenerator variableGenerator, boolean topLevel) {
        if (d1.equals(d2)) {
            return Optional.of(d1.isGround() || topLevel && d1 instanceof Variable ? d1 : this.replaceVariablesByFreshOnes((NonGroundTerm)d1, variableGenerator));
        }
        if (d1 instanceof Variable) {
            return topLevel ? Optional.empty() : Optional.of(variableGenerator.generateNewVariableFromVar((Variable)d1));
        }
        if (d2 instanceof Variable) {
            return topLevel ? Optional.empty() : Optional.of(variableGenerator.generateNewVariableFromVar((Variable)d2));
        }
        if (d1 instanceof ImmutableFunctionalTerm && d2 instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm1 = (ImmutableFunctionalTerm)d1;
            ImmutableFunctionalTerm functionalTerm2 = (ImmutableFunctionalTerm)d2;
            if (!functionalTerm1.getFunctionSymbol().equals(functionalTerm2.getFunctionSymbol())) {
                return topLevel ? Optional.empty() : Optional.of(variableGenerator.generateNewVariable());
            }
            ImmutableList<? extends ImmutableTerm> arguments1 = functionalTerm1.getTerms();
            ImmutableList<? extends ImmutableTerm> arguments2 = functionalTerm2.getTerms();
            if (arguments1.size() != arguments2.size()) {
                throw new IllegalStateException("Functions have different arities, they cannot be combined");
            }
            ImmutableList.Builder argumentBuilder = ImmutableList.builder();
            for (int i = 0; i < arguments1.size(); ++i) {
                ImmutableTerm newArgument = this.combineDefinitions((ImmutableTerm)arguments1.get(i), (ImmutableTerm)arguments2.get(i), variableGenerator, false).orElseGet(variableGenerator::generateNewVariable);
                argumentBuilder.add((Object)newArgument);
            }
            return Optional.of(this.termFactory.getImmutableFunctionalTerm(functionalTerm1.getFunctionSymbol(), (ImmutableList<? extends ImmutableTerm>)argumentBuilder.build()));
        }
        return Optional.empty();
    }

    private NonGroundTerm replaceVariablesByFreshOnes(NonGroundTerm term, VariableGenerator variableGenerator) {
        if (term instanceof Variable) {
            return variableGenerator.generateNewVariableFromVar((Variable)term);
        }
        NonGroundFunctionalTerm functionalTerm = (NonGroundFunctionalTerm)term;
        return this.termFactory.getNonGroundFunctionalTerm(functionalTerm.getFunctionSymbol(), (ImmutableList<ImmutableTerm>)((ImmutableList)functionalTerm.getTerms().stream().map(a -> a.isGround() ? a : this.replaceVariablesByFreshOnes((NonGroundTerm)a, variableGenerator)).collect(ImmutableCollectors.toList())));
    }

    private IQTree updateChild(UnaryIQTree liftedChildTree, ImmutableSubstitution<ImmutableTerm> mergedSubstitution, ImmutableSubstitution<ImmutableTerm> tmpNormalizedSubstitution, ImmutableSet<Variable> projectedVariables) {
        ConstructionNode constructionNode = (ConstructionNode)liftedChildTree.getRootNode();
        ConstructionNodeTools.NewSubstitutionPair substitutionPair = this.constructionTools.traverseConstructionNode(mergedSubstitution, tmpNormalizedSubstitution, constructionNode.getVariables(), projectedVariables);
        ImmutableSubstitution descendingSubstitution = this.substitutionFactory.getSubstitution(substitutionPair.propagatedSubstitution.getImmutableMap());
        IQTree newChild = liftedChildTree.getChild().applyDescendingSubstitution(descendingSubstitution, Optional.empty());
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(projectedVariables, substitutionPair.bindings.simplifyValues());
        return substitutionPair.bindings.isEmpty() ? newChild : this.iqFactory.createUnaryIQTree(newConstructionNode, newChild);
    }
}

