/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.impl.QueryModifierNodeImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import javax.annotation.Nullable;

public class SliceNodeImpl
extends QueryModifierNodeImpl
implements SliceNode {
    private static final String SLICE_STR = "SLICE";
    private final long offset;
    @Nullable
    private final Long limit;

    @AssistedInject
    private SliceNodeImpl(@Assisted(value="offset") long offset, @Assisted(value="limit") long limit, IntermediateQueryFactory iqFactory) {
        super(iqFactory);
        if (offset < 0L) {
            throw new IllegalArgumentException("The offset must not be negative");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit must not be negative");
        }
        this.offset = offset;
        this.limit = limit;
    }

    @AssistedInject
    private SliceNodeImpl(@Assisted long offset, IntermediateQueryFactory iqFactory) {
        super(iqFactory);
        if (offset < 0L) {
            throw new IllegalArgumentException("The offset must not be negative");
        }
        this.offset = offset;
        this.limit = null;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child);
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        if (this.limit != null && this.limit == 0L) {
            return this.iqFactory.createEmptyNode(child.getVariables());
        }
        IQTree newChild = child.normalizeForOptimization(variableGenerator);
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof ConstructionNode) {
            return this.liftChildConstruction((ConstructionNode)newChildRoot, (UnaryIQTree)newChild, variableGenerator);
        }
        if (newChildRoot instanceof SliceNode) {
            return this.mergeWithSliceChild((SliceNode)newChildRoot, newChild, currentIQProperties);
        }
        if (newChildRoot instanceof EmptyNode) {
            return newChild;
        }
        if (newChildRoot instanceof TrueNode || newChildRoot instanceof AggregationNode && ((AggregationNode)newChildRoot).getGroupingVariables().isEmpty()) {
            return this.offset > 0L ? this.iqFactory.createEmptyNode(child.getVariables()) : newChild;
        }
        if (newChildRoot instanceof DistinctNode && this.offset == 0L && this.getLimit().filter(l -> l <= 1L).isPresent()) {
            return this.normalizeForOptimization(((UnaryIQTree)child).getChild(), variableGenerator, currentIQProperties);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, newChild, currentIQProperties.declareNormalizedForOptimization());
    }

    private IQTree liftChildConstruction(ConstructionNode childConstructionNode, UnaryIQTree childTree, VariableGenerator variableGenerator) {
        IQTree newSliceLevelTree = this.iqFactory.createUnaryIQTree(this, childTree.getChild()).normalizeForOptimization(variableGenerator);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)childConstructionNode, newSliceLevelTree, this.iqFactory.createIQProperties().declareNormalizedForOptimization());
    }

    private IQTree mergeWithSliceChild(SliceNode newChildRoot, IQTree newChild, IQProperties currentIQProperties) {
        long newOffset = this.offset + newChildRoot.getOffset();
        Optional newLimit = newChildRoot.getLimit().map(cl -> Math.max(cl - this.offset, 0L)).map(cl -> this.getLimit().map(l -> Math.min(cl, l)).orElse((Long)cl)).map(Optional::of).orElseGet(this::getLimit);
        SliceNode newSliceNode = newLimit.map(l -> this.iqFactory.createSliceNode(newOffset, (long)l)).orElseGet(() -> this.iqFactory.createSliceNode(newOffset));
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newSliceNode, newChild, currentIQProperties.declareNormalizedForOptimization());
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child) {
        return this.iqFactory.createUnaryIQTree(this, child.applyDescendingSubstitution(descendingSubstitution, constraint));
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child) {
        return this.iqFactory.createUnaryIQTree(this, child.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution));
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, newChild, newTreeCache);
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        if (this.limit != null && this.limit <= 1L) {
            return true;
        }
        return child.isDistinct();
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformSlice(tree, this, child);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitSlice(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQProperties iqProperties) {
        IQTree newChild = child.removeDistincts();
        IQProperties newProperties = newChild.equals(child) ? iqProperties.declareDistinctRemovalWithoutEffect() : iqProperties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, newChild, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return child.inferUniqueConstraints();
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(IQTree child) {
        return child.getNotInternallyRequiredVariables();
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SliceNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return queryNode instanceof SliceNode && ((SliceNode)queryNode).getOffset() == this.offset && ((SliceNode)queryNode).getLimit().equals(this.getLimit());
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return this.isEquivalentTo(node);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Optional<Long> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    public SliceNode clone() {
        return this.getLimit().map(l -> this.iqFactory.createSliceNode(this.offset, (long)l)).orElseGet(() -> this.iqFactory.createSliceNode(this.offset));
    }

    public String toString() {
        return SLICE_STR + (this.offset > 0L ? " offset=" + this.offset : "") + (this.limit == null ? "" : " limit=" + this.limit);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child) {
        return this.iqFactory.createUnaryIQTree(this, child);
    }
}

