/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.exception.IllegalTreeUpdateException;
import it.unibz.inf.ontop.iq.impl.tree.BinaryChildrenRelation;
import it.unibz.inf.ontop.iq.impl.tree.ChildrenRelation;
import it.unibz.inf.ontop.iq.impl.tree.QueryTree;
import it.unibz.inf.ontop.iq.impl.tree.StandardChildrenRelation;
import it.unibz.inf.ontop.iq.impl.tree.TreeNode;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultTree
implements QueryTree {
    private TreeNode rootNode;
    private final Map<QueryNode, TreeNode> nodeIndex;
    private final Map<TreeNode, ChildrenRelation> childrenIndex;
    private final Map<TreeNode, TreeNode> parentIndex;
    private final Set<TrueNode> trueNodes;
    private final Set<IntensionalDataNode> intensionalNodes;
    private UUID versionNumber;

    protected DefaultTree(QueryNode rootQueryNode) {
        this.nodeIndex = new HashMap<QueryNode, TreeNode>();
        this.childrenIndex = new HashMap<TreeNode, ChildrenRelation>();
        this.parentIndex = new HashMap<TreeNode, TreeNode>();
        this.trueNodes = new HashSet<TrueNode>();
        this.intensionalNodes = new HashSet<IntensionalDataNode>();
        this.rootNode = new TreeNode(rootQueryNode);
        this.insertNodeIntoIndex(rootQueryNode, this.rootNode);
        this.childrenIndex.put(this.rootNode, DefaultTree.createChildrenRelation(this.rootNode));
        this.versionNumber = UUID.randomUUID();
    }

    private DefaultTree(TreeNode rootNode, Map<QueryNode, TreeNode> nodeIndex, Map<TreeNode, ChildrenRelation> childrenIndex, Map<TreeNode, TreeNode> parentIndex, Set<TrueNode> trueNodes, Set<IntensionalDataNode> intensionalNodes, UUID versionNumber) {
        this.rootNode = rootNode;
        this.nodeIndex = nodeIndex;
        this.childrenIndex = childrenIndex;
        this.parentIndex = parentIndex;
        this.trueNodes = trueNodes;
        this.intensionalNodes = intensionalNodes;
        this.versionNumber = versionNumber;
    }

    @Override
    public QueryNode getRootNode() {
        return this.rootNode.getQueryNode();
    }

    @Override
    public void addChild(QueryNode parentQueryNode, QueryNode childQueryNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition, boolean mustBeNew, boolean canReplace) throws IllegalTreeUpdateException {
        TreeNode parentNode = this.accessTreeNode(parentQueryNode);
        if (this.nodeIndex.containsKey(childQueryNode)) {
            if (mustBeNew) {
                throw new IllegalTreeUpdateException("Node " + childQueryNode + " already in the graph");
            }
            TreeNode childNode = this.accessTreeNode(childQueryNode);
            TreeNode previousParent = this.getParentTreeNode(childNode);
            if (previousParent != null) {
                this.removeChild(previousParent, childNode);
            }
            this.parentIndex.put(childNode, parentNode);
            this.accessChildrenRelation(parentNode).addChild(childNode, optionalPosition, canReplace);
        } else {
            this.createNewNode(childQueryNode, parentNode, optionalPosition, canReplace);
        }
    }

    private void createNewNode(QueryNode childQueryNode, TreeNode parentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition, boolean canReplace) throws IllegalTreeUpdateException {
        TreeNode childNode = new TreeNode(childQueryNode);
        this.insertNodeIntoIndex(childQueryNode, childNode);
        this.childrenIndex.put(childNode, DefaultTree.createChildrenRelation(childNode));
        this.parentIndex.put(childNode, parentNode);
        this.accessChildrenRelation(parentNode).addChild(childNode, optionalPosition, canReplace);
    }

    private static ChildrenRelation createChildrenRelation(TreeNode parentTreeNode) {
        if (parentTreeNode.getQueryNode() instanceof BinaryOrderedOperatorNode) {
            return new BinaryChildrenRelation(parentTreeNode);
        }
        return new StandardChildrenRelation(parentTreeNode);
    }

    @Override
    public ImmutableList<QueryNode> getChildren(QueryNode node) {
        ChildrenRelation childrenRelation = this.accessChildrenRelation(this.accessTreeNode(node));
        if (childrenRelation == null) {
            return ImmutableList.of();
        }
        return childrenRelation.getChildQueryNodes();
    }

    @Override
    public Stream<QueryNode> getChildrenStream(QueryNode node) {
        ChildrenRelation childrenRelation = this.accessChildrenRelation(this.accessTreeNode(node));
        if (childrenRelation == null) {
            return Stream.of(new QueryNode[0]);
        }
        return childrenRelation.getChildQueryNodeStream();
    }

    @Override
    public boolean contains(QueryNode node) {
        return this.nodeIndex.containsKey(node);
    }

    @Override
    public ImmutableList<QueryNode> getNodesInBottomUpOrder() {
        return this.getNodesInTopDownOrder().reverse();
    }

    @Override
    public ImmutableList<QueryNode> getNodesInTopDownOrder() {
        LinkedList<TreeNode> nodesToExplore = new LinkedList<TreeNode>();
        ImmutableList.Builder builder = ImmutableList.builder();
        nodesToExplore.add(this.rootNode);
        builder.add((Object)this.rootNode.getQueryNode());
        while (!nodesToExplore.isEmpty()) {
            TreeNode node = (TreeNode)nodesToExplore.poll();
            for (TreeNode childNode : this.accessChildrenRelation(node).getChildren()) {
                nodesToExplore.add(childNode);
                builder.add((Object)childNode.getQueryNode());
            }
        }
        return builder.build();
    }

    @Override
    public void replaceNode(QueryNode previousNode, QueryNode replacingNode) {
        TreeNode treeNode = this.accessTreeNode(previousNode);
        if (treeNode == null) {
            throw new IllegalArgumentException("The previous query node must be in the tree");
        }
        if (this.contains(replacingNode)) {
            throw new IllegalArgumentException("The replacing node must not be already in the tree");
        }
        treeNode.changeQueryNode(replacingNode);
        this.removeNodeFromIndex(previousNode);
        this.insertNodeIntoIndex(replacingNode, treeNode);
        if (!(previousNode instanceof BinaryOrderedOperatorNode) && replacingNode instanceof BinaryOrderedOperatorNode) {
            ChildrenRelation newChildrenRelation = this.accessChildrenRelation(treeNode).convertToBinaryChildrenRelation();
            this.childrenIndex.put(treeNode, newChildrenRelation);
        } else if (previousNode instanceof BinaryOrderedOperatorNode && !(replacingNode instanceof BinaryOrderedOperatorNode)) {
            ChildrenRelation newChildrenRelation = this.accessChildrenRelation(treeNode).convertToStandardChildrenRelation();
            this.childrenIndex.put(treeNode, newChildrenRelation);
        }
    }

    @Override
    public void removeSubTree(QueryNode subQueryTreeRoot) {
        TreeNode subTreeRoot = this.accessTreeNode(subQueryTreeRoot);
        LinkedList<TreeNode> nodesToRemove = new LinkedList<TreeNode>();
        nodesToRemove.add(subTreeRoot);
        while (!nodesToRemove.isEmpty()) {
            TreeNode treeNode = (TreeNode)nodesToRemove.poll();
            nodesToRemove.addAll((Collection<TreeNode>)this.accessChildrenRelation(treeNode).getChildren());
            this.removeNode(treeNode);
        }
    }

    @Override
    public ImmutableList<QueryNode> getSubTreeNodesInTopDownOrder(QueryNode currentQueryNode) {
        TreeNode currentTreeNode = this.accessTreeNode(currentQueryNode);
        LinkedList<TreeNode> nodesToExplore = new LinkedList<TreeNode>();
        ImmutableList.Builder builder = ImmutableList.builder();
        nodesToExplore.add(currentTreeNode);
        while (!nodesToExplore.isEmpty()) {
            TreeNode node = (TreeNode)nodesToExplore.poll();
            for (TreeNode childNode : this.accessChildrenRelation(node).getChildren()) {
                nodesToExplore.add(childNode);
                builder.add((Object)childNode.getQueryNode());
            }
        }
        return builder.build();
    }

    @Override
    public Optional<QueryNode> getParent(QueryNode childQueryNode) {
        TreeNode childTreeNode = this.accessTreeNode(childQueryNode);
        TreeNode parentTreeNode = this.getParentTreeNode(childTreeNode);
        if (parentTreeNode == null) {
            return Optional.empty();
        }
        return Optional.of(parentTreeNode.getQueryNode());
    }

    @Override
    public QueryNode removeOrReplaceNodeByUniqueChild(QueryNode parentQueryNode) throws IllegalTreeUpdateException {
        TreeNode parentTreeNode = this.accessTreeNode(parentQueryNode);
        this.removeNodeFromIndex(parentQueryNode);
        ImmutableList<TreeNode> children = this.accessChildrenRelation(parentTreeNode).getChildren();
        if (children.size() == 1) {
            TreeNode childTreeNode = (TreeNode)children.get(0);
            this.childrenIndex.remove(parentTreeNode);
            TreeNode grandParentTreeNode = this.getParentTreeNode(parentTreeNode);
            this.parentIndex.remove(parentTreeNode);
            if (grandParentTreeNode == null) {
                this.rootNode = childTreeNode;
                this.parentIndex.remove(childTreeNode);
            } else {
                this.parentIndex.put(childTreeNode, grandParentTreeNode);
                ChildrenRelation grandParentRelation = this.accessChildrenRelation(grandParentTreeNode);
                grandParentRelation.replaceChild(parentTreeNode, childTreeNode);
            }
            return childTreeNode.getQueryNode();
        }
        throw new IllegalTreeUpdateException("The query node " + parentQueryNode + " does not have a unique child");
    }

    @Override
    public void replaceNodesByOneNode(ImmutableList<QueryNode> nodesToRemove, QueryNode replacingNode, QueryNode parentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) throws IllegalTreeUpdateException {
        if (replacingNode instanceof BinaryOrderedOperatorNode) {
            throw new RuntimeException("Having a BinaryAsymmetricOperatorNode replacing node is not yet supported");
        }
        this.addChild(parentNode, replacingNode, optionalPosition, true, true);
        for (QueryNode nodeToRemove : nodesToRemove) {
            boolean isParentBinaryAsymmetricOperator = nodeToRemove instanceof BinaryOrderedOperatorNode;
            TreeNode treeNodeToRemove = this.accessTreeNode(nodeToRemove);
            for (QueryNode child : this.accessChildrenRelation(treeNodeToRemove).getChildQueryNodes()) {
                if (nodesToRemove.contains((Object)child)) continue;
                if (isParentBinaryAsymmetricOperator) {
                    throw new RuntimeException("Re-integrating children of a BinaryAsymmetricOperatorNode is not yet supported");
                }
                this.addChild(replacingNode, child, Optional.empty(), false, true);
            }
            this.removeNode(treeNodeToRemove);
        }
    }

    @Override
    public Optional<BinaryOrderedOperatorNode.ArgumentPosition> getOptionalPosition(QueryNode parentNode, QueryNode childNode) {
        TreeNode parentTreeNode = this.accessTreeNode(parentNode);
        TreeNode childTreeNode = this.accessTreeNode(childNode);
        ChildrenRelation childrenRelation = this.accessChildrenRelation(parentTreeNode);
        return childrenRelation.getOptionalPosition(childTreeNode);
    }

    @Override
    public void insertParent(QueryNode childNode, QueryNode newParentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) throws IllegalTreeUpdateException {
        if (this.contains(newParentNode)) {
            throw new IllegalTreeUpdateException(newParentNode + " is already present so cannot be inserted again");
        }
        TreeNode childTreeNode = this.accessTreeNode(childNode);
        TreeNode newParentTreeNode = new TreeNode(newParentNode);
        this.insertNodeIntoIndex(newParentNode, newParentTreeNode);
        this.childrenIndex.put(newParentTreeNode, DefaultTree.createChildrenRelation(newParentTreeNode));
        Optional<QueryNode> optionalFormerParent = this.getParent(childNode);
        if (!optionalFormerParent.isPresent()) {
            this.rootNode = newParentTreeNode;
        } else {
            QueryNode grandParentNode = optionalFormerParent.get();
            TreeNode grandParentTreeNode = this.accessTreeNode(grandParentNode);
            this.changeChild(grandParentTreeNode, childTreeNode, newParentTreeNode);
        }
        this.addChild(newParentNode, childNode, optionalPosition, false, false);
    }

    @Override
    public ImmutableSet<TrueNode> getTrueNodes() {
        return ImmutableSet.copyOf(this.trueNodes);
    }

    @Override
    public ImmutableSet<IntensionalDataNode> getIntensionalNodes() {
        return ImmutableSet.copyOf(this.intensionalNodes);
    }

    @Override
    public QueryNode replaceNodeByChild(QueryNode parentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalReplacingChildPosition) {
        TreeNode childTreeNode;
        TreeNode parentTreeNode = this.accessTreeNode(parentNode);
        ChildrenRelation childrenRelation = this.accessChildrenRelation(parentTreeNode);
        if (optionalReplacingChildPosition.isPresent()) {
            childTreeNode = childrenRelation.getChild(optionalReplacingChildPosition.get()).orElseThrow(() -> new IllegalTreeUpdateException("No child at the position" + optionalReplacingChildPosition.get()));
        } else {
            ImmutableList<TreeNode> children = childrenRelation.getChildren();
            if (children.isEmpty()) {
                throw new IllegalTreeUpdateException("The node cannot be replaced by a child (does not have any)");
            }
            childTreeNode = (TreeNode)children.get(0);
        }
        this.childrenIndex.remove(parentTreeNode);
        TreeNode grandParentTreeNode = this.getParentTreeNode(parentTreeNode);
        this.parentIndex.remove(parentTreeNode);
        if (grandParentTreeNode == null) {
            this.rootNode = childTreeNode;
            this.parentIndex.remove(childTreeNode);
        } else {
            this.parentIndex.put(childTreeNode, grandParentTreeNode);
            ChildrenRelation grandParentRelation = this.accessChildrenRelation(grandParentTreeNode);
            grandParentRelation.replaceChild(parentTreeNode, childTreeNode);
        }
        return childTreeNode.getQueryNode();
    }

    @Override
    public QueryTree createSnapshot() {
        Map<QueryNode, TreeNode> newNodeIndex = this.nodeIndex.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((TreeNode)e.getValue()).cloneShallowly())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<TreeNode, ChildrenRelation> newChildrenIndex = this.childrenIndex.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<TreeNode, ChildrenRelation>(((TreeNode)e.getKey()).findNewTreeNode(newNodeIndex), ((ChildrenRelation)e.getValue()).clone(newNodeIndex))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<TreeNode, TreeNode> newParentIndex = this.parentIndex.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<TreeNode, TreeNode>(((TreeNode)e.getKey()).findNewTreeNode(newNodeIndex), ((TreeNode)e.getValue()).findNewTreeNode(newNodeIndex))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new DefaultTree(newNodeIndex.get(this.rootNode.getQueryNode()), newNodeIndex, newChildrenIndex, newParentIndex, new HashSet<TrueNode>(this.trueNodes), new HashSet<IntensionalDataNode>(this.intensionalNodes), this.versionNumber);
    }

    @Override
    public void transferChild(QueryNode childNode, QueryNode formerParentNode, QueryNode newParentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) {
        TreeNode formerParentTreeNode = this.accessTreeNode(formerParentNode);
        TreeNode childTreeNode = this.accessTreeNode(childNode);
        this.accessChildrenRelation(formerParentTreeNode).removeChild(childTreeNode);
        this.addChild(newParentNode, childNode, optionalPosition, false, false);
    }

    @Override
    public UUID getVersionNumber() {
        return this.versionNumber;
    }

    private void updateVersionNumber() {
        this.versionNumber = UUID.randomUUID();
    }

    private void removeNode(TreeNode treeNode) {
        this.removeNodeFromIndex(treeNode.getQueryNode());
        TreeNode parentNode = this.getParentTreeNode(treeNode);
        if (parentNode != null) {
            this.accessChildrenRelation(parentNode).removeChild(treeNode);
        }
        this.parentIndex.remove(treeNode);
        for (TreeNode childTreeNode : this.childrenIndex.get(treeNode).getChildren()) {
            this.parentIndex.remove(childTreeNode);
        }
        this.childrenIndex.remove(treeNode);
    }

    private void removeChild(TreeNode parentNode, TreeNode childNodeToRemove) {
        if (this.getParentTreeNode(childNodeToRemove) == parentNode) {
            this.parentIndex.remove(childNodeToRemove);
        }
        if (this.childrenIndex.containsKey(parentNode)) {
            this.accessChildrenRelation(parentNode).removeChild(childNodeToRemove);
        }
    }

    private void changeChild(TreeNode parentNode, TreeNode childNodeToReplace, TreeNode replacingChild) {
        if (this.getParentTreeNode(childNodeToReplace) != parentNode) {
            throw new IllegalArgumentException(childNodeToReplace + " is not the child of " + parentNode);
        }
        this.parentIndex.remove(childNodeToReplace);
        this.parentIndex.put(replacingChild, parentNode);
        if (!this.childrenIndex.containsKey(parentNode)) {
            throw new IllegalTreeUpdateException(parentNode + " has no childrenRelation");
        }
        this.accessChildrenRelation(parentNode).replaceChild(childNodeToReplace, replacingChild);
    }

    private TreeNode accessTreeNode(QueryNode node) {
        TreeNode treeNode = this.nodeIndex.get(node);
        if (treeNode == null) {
            throw new IllegalArgumentException("The given query node is not in the tree");
        }
        return treeNode;
    }

    private ChildrenRelation accessChildrenRelation(TreeNode node) {
        ChildrenRelation relation = this.childrenIndex.get(node);
        if (relation == null) {
            throw new RuntimeException("Internal error: the tree node does not have a children relation.");
        }
        return relation;
    }

    private TreeNode getParentTreeNode(TreeNode child) {
        TreeNode parentTreeNode = this.parentIndex.get(child);
        if (parentTreeNode == null) {
            return null;
        }
        if (this.contains(parentTreeNode.getQueryNode())) {
            return parentTreeNode;
        }
        throw new RuntimeException("Internal error: points to a parent that is not (anymore) in the tree");
    }

    private void insertNodeIntoIndex(QueryNode queryNode, TreeNode treeNode) {
        this.nodeIndex.put(queryNode, treeNode);
        if (queryNode instanceof TrueNode) {
            this.trueNodes.add((TrueNode)queryNode);
        } else if (queryNode instanceof IntensionalDataNode) {
            this.intensionalNodes.add((IntensionalDataNode)queryNode);
        }
        this.updateVersionNumber();
    }

    private void removeNodeFromIndex(QueryNode queryNode) {
        this.nodeIndex.remove(queryNode);
        if (queryNode instanceof TrueNode) {
            this.trueNodes.remove(queryNode);
        } else if (queryNode instanceof IntensionalDataNode) {
            this.intensionalNodes.remove(queryNode);
        }
        this.updateVersionNumber();
    }
}

