/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.ConcreteIQTreeCache;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ConcreteIQTreeCacheImpl
implements ConcreteIQTreeCache {
    private final boolean isNormalizedForOptimization;
    private final boolean areDistinctAlreadyRemoved;
    private final CoreSingletons coreSingletons;
    @Nullable
    private VariableNullability variableNullability;
    @Nullable
    private ImmutableSet<Variable> variables;
    @Nullable
    private ImmutableSet<Variable> notInternallyRequiredVariables;
    @Nullable
    private ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleVariableDefinitions;
    @Nullable
    private ImmutableSet<ImmutableSet<Variable>> uniqueConstraints;
    @Nullable
    private Boolean isDistinct;

    @Inject
    protected ConcreteIQTreeCacheImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.isNormalizedForOptimization = false;
        this.areDistinctAlreadyRemoved = false;
    }

    protected ConcreteIQTreeCacheImpl(CoreSingletons coreSingletons, boolean isNormalizedForOptimization, boolean areDistinctAlreadyRemoved, @Nullable VariableNullability variableNullability, @Nullable ImmutableSet<Variable> variables, @Nullable ImmutableSet<Variable> notInternallyRequiredVariables, @Nullable ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleVariableDefinitions, @Nullable ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, @Nullable Boolean isDistinct) {
        this.isNormalizedForOptimization = isNormalizedForOptimization;
        this.areDistinctAlreadyRemoved = areDistinctAlreadyRemoved;
        this.coreSingletons = coreSingletons;
        this.variableNullability = variableNullability;
        this.variables = variables;
        this.notInternallyRequiredVariables = notInternallyRequiredVariables;
        this.possibleVariableDefinitions = possibleVariableDefinitions;
        this.uniqueConstraints = uniqueConstraints;
        this.isDistinct = isDistinct;
    }

    @Override
    public boolean isNormalizedForOptimization() {
        return this.isNormalizedForOptimization;
    }

    @Override
    public boolean areDistinctAlreadyRemoved() {
        return this.areDistinctAlreadyRemoved;
    }

    @Override
    @Nullable
    public ImmutableSet<Variable> getVariables() {
        return this.variables;
    }

    @Override
    @Nullable
    public ImmutableSet<Variable> getNotInternallyRequiredVariables() {
        return this.notInternallyRequiredVariables;
    }

    @Override
    @Nullable
    public VariableNullability getVariableNullability() {
        return this.variableNullability;
    }

    @Override
    @Nullable
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions() {
        return this.possibleVariableDefinitions;
    }

    @Override
    @Nullable
    public ImmutableSet<ImmutableSet<Variable>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    @Nullable
    public Boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public void setVariables(@Nonnull ImmutableSet<Variable> variables) {
        this.variables = variables;
    }

    @Override
    public void setNotInternallyRequiredVariables(@Nonnull ImmutableSet<Variable> notInternallyRequiredVariables) {
        this.notInternallyRequiredVariables = notInternallyRequiredVariables;
    }

    @Override
    public IQTreeCache declareAsNormalizedForOptimizationWithoutEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, true, this.areDistinctAlreadyRemoved, this.variableNullability, this.variables, this.notInternallyRequiredVariables, this.possibleVariableDefinitions, this.uniqueConstraints, this.isDistinct);
    }

    @Override
    public IQTreeCache declareAsNormalizedForOptimizationWithEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, true, this.areDistinctAlreadyRemoved, this.variableNullability, this.variables, null, null, null, null);
    }

    @Override
    public IQTreeCache declareConstraintPushedDownWithEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, false, this.areDistinctAlreadyRemoved, null, this.variables, null, null, null, null);
    }

    @Override
    public IQTreeCache declareDistinctRemovalWithoutEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, this.isNormalizedForOptimization, true, this.variableNullability, this.variables, this.notInternallyRequiredVariables, this.possibleVariableDefinitions, this.uniqueConstraints, this.isDistinct);
    }

    @Override
    public IQTreeCache declareDistinctRemovalWithEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, false, true, this.variableNullability, this.variables, null, this.possibleVariableDefinitions, null, null);
    }

    @Override
    public synchronized void setVariableNullability(VariableNullability variableNullability) {
        if (this.variableNullability != null) {
            throw new IllegalStateException("Variable nullability already present. Only call this method once");
        }
        this.variableNullability = variableNullability;
    }

    @Override
    public synchronized void setPossibleVariableDefinitions(@Nonnull ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleVariableDefinitions) {
        if (this.possibleVariableDefinitions != null) {
            throw new IllegalStateException("Possible variable definitions already present. Only call this method once");
        }
        this.possibleVariableDefinitions = possibleVariableDefinitions;
    }

    @Override
    public void setUniqueConstraints(ImmutableSet<ImmutableSet<Variable>> uniqueConstraints) {
        if (this.uniqueConstraints != null) {
            throw new IllegalStateException("Unique constraints already present. Only call this method once");
        }
        this.uniqueConstraints = uniqueConstraints;
    }

    @Override
    public void setIsDistinct(@Nonnull Boolean isDistinct) {
        if (this.isDistinct != null) {
            throw new IllegalStateException("Distinct information is already present. Only call this method once");
        }
        this.isDistinct = isDistinct;
    }

    @Override
    public IQProperties convertIntoIQProperties() {
        IQProperties properties = this.coreSingletons.getIQFactory().createIQProperties();
        if (this.areDistinctAlreadyRemoved) {
            properties = properties.declareDistinctRemovalWithoutEffect();
        }
        if (this.isNormalizedForOptimization) {
            properties = properties.declareNormalizedForOptimization();
        }
        return properties;
    }

    @Override
    public IQTreeCache applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution) {
        VariableNullability newVariableNullability = this.variableNullability == null ? null : this.variableNullability.applyFreshRenaming(renamingSubstitution);
        ImmutableSet newVariables = this.variables == null ? null : (ImmutableSet)this.variables.stream().map(renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet());
        ImmutableSet newNotInternallyRequiredVariables = this.notInternallyRequiredVariables == null ? null : (ImmutableSet)this.notInternallyRequiredVariables.stream().map(renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet());
        ImmutableSet newPossibleDefinitions = this.possibleVariableDefinitions == null ? null : (ImmutableSet)this.possibleVariableDefinitions.stream().map(renamingSubstitution::applyRenaming).collect(ImmutableCollectors.toSet());
        ImmutableSet newUniqueConstraints = this.uniqueConstraints == null ? null : (ImmutableSet)this.uniqueConstraints.stream().map(vs -> (ImmutableSet)vs.stream().map(renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet())).collect(ImmutableCollectors.toSet());
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, this.isNormalizedForOptimization, this.areDistinctAlreadyRemoved, newVariableNullability, (ImmutableSet<Variable>)newVariables, (ImmutableSet<Variable>)newNotInternallyRequiredVariables, (ImmutableSet<ImmutableSubstitution<NonVariableTerm>>)newPossibleDefinitions, (ImmutableSet<ImmutableSet<Variable>>)newUniqueConstraints, this.isDistinct);
    }
}

