/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.CompositeIQTree;
import it.unibz.inf.ontop.iq.ConcreteIQTreeCache;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class AbstractCompositeIQTree<N extends QueryNode>
implements CompositeIQTree<N> {
    private final N rootNode;
    private final ImmutableList<IQTree> children;
    private final ConcreteIQTreeCache treeCache;
    private static final String TAB_STR = "   ";
    @Nullable
    private ImmutableSet<Variable> knownVariables;
    @Nullable
    private String string;
    private boolean hasBeenSuccessfullyValidate;
    protected final IQTreeTools iqTreeTools;
    protected final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    protected AbstractCompositeIQTree(N rootNode, ImmutableList<IQTree> children, IQProperties iqProperties, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this(rootNode, children, AbstractCompositeIQTree.convertIQProperties(iqProperties), iqTreeTools, iqFactory, termFactory);
    }

    protected AbstractCompositeIQTree(N rootNode, ImmutableList<IQTree> children, IQTreeCache treeCache, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this.iqTreeTools = iqTreeTools;
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        if (children.isEmpty()) {
            throw new IllegalArgumentException("A composite IQ must have at least one child");
        }
        this.rootNode = rootNode;
        this.children = children;
        if (!(treeCache instanceof ConcreteIQTreeCache)) {
            throw new IllegalArgumentException("Was expecting the tree cache to be instance of ConcreteIQTreeCache");
        }
        this.treeCache = (ConcreteIQTreeCache)treeCache;
        this.knownVariables = null;
        this.hasBeenSuccessfullyValidate = false;
    }

    private static IQTreeCache convertIQProperties(IQProperties iqProperties) {
        return iqProperties.convertIQTreeCache();
    }

    @Override
    public N getRootNode() {
        return this.rootNode;
    }

    @Override
    public ImmutableList<IQTree> getChildren() {
        return this.children;
    }

    @Override
    public synchronized ImmutableSet<Variable> getVariables() {
        ImmutableSet<Variable> variables = this.treeCache.getVariables();
        if (variables != null) {
            return variables;
        }
        variables = this.computeVariables();
        this.treeCache.setVariables(variables);
        return variables;
    }

    protected ImmutableSet<Variable> computeVariables() {
        if (this.rootNode instanceof ExplicitVariableProjectionNode) {
            return ((ExplicitVariableProjectionNode)this.rootNode).getVariables();
        }
        return (ImmutableSet)this.children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        if (this.knownVariables == null) {
            this.knownVariables = (ImmutableSet)Stream.concat(this.getRootNode().getLocalVariables().stream(), this.getChildren().stream().flatMap(c -> c.getKnownVariables().stream())).collect(ImmutableCollectors.toSet());
        }
        return this.knownVariables;
    }

    public String toString() {
        if (this.string == null) {
            this.string = AbstractCompositeIQTree.printSubtree(this, "");
        }
        return this.string;
    }

    private static String printSubtree(IQTree subTree, String offset) {
        String childOffset = offset + TAB_STR;
        return offset + subTree.getRootNode() + "\n" + subTree.getChildren().stream().map(c -> AbstractCompositeIQTree.printSubtree(c, childOffset)).reduce("", (c, a) -> c + a);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof CompositeIQTree && this.isEquivalentTo((CompositeIQTree)o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isEquivalentTo(IQTree tree) {
        if (!this.getRootNode().isEquivalentTo(tree.getRootNode())) {
            return false;
        }
        ImmutableList<IQTree> otherChildren = tree.getChildren();
        return this.children.size() == otherChildren.size() && IntStream.range(0, this.children.size()).allMatch(i -> ((IQTree)this.children.get(i)).isEquivalentTo((IQTree)otherChildren.get(i)));
    }

    protected IQProperties getProperties() {
        return this.treeCache.convertIntoIQProperties();
    }

    protected Optional<ImmutableSubstitution<? extends VariableOrGroundTerm>> normalizeDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) throws IQTreeTools.UnsatisfiableDescendingSubstitutionException {
        return this.iqTreeTools.normalizeDescendingSubstitution(this, descendingSubstitution);
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint) {
        try {
            Optional<ImmutableSubstitution<VariableOrGroundTerm>> normalizedSubstitution = this.normalizeDescendingSubstitution(descendingSubstitution);
            Optional<ImmutableExpression> newConstraint = this.normalizeConstraint(constraint, descendingSubstitution);
            return normalizedSubstitution.flatMap(this::extractFreshRenaming).map(s -> this.applyFreshRenaming((InjectiveVar2VarSubstitution)s, true)).map(t -> newConstraint.map(t::propagateDownConstraint).orElse((IQTree)t)).orElseGet(() -> normalizedSubstitution.map(s -> this.applyRegularDescendingSubstitution((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, newConstraint)).orElseGet(() -> newConstraint.map(this::propagateDownConstraint).orElse(this)));
        }
        catch (IQTreeTools.UnsatisfiableDescendingSubstitutionException e) {
            return this.iqFactory.createEmptyNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.getVariables()));
        }
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution freshRenamingSubstitution) {
        return this.applyFreshRenaming(freshRenamingSubstitution, false);
    }

    @Override
    public IQTree applyFreshRenamingToAllVariables(InjectiveVar2VarSubstitution freshRenamingSubstitution) {
        return this.applyFreshRenaming(freshRenamingSubstitution, true);
    }

    private Optional<ImmutableExpression> normalizeConstraint(Optional<ImmutableExpression> constraint, ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) {
        if (!constraint.isPresent()) {
            return constraint;
        }
        ImmutableSet newVariables = (ImmutableSet)this.getVariables().stream().map(descendingSubstitution::apply).filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
        return this.termFactory.getConjunction(constraint.get().flattenAND().filter(e -> e.getVariableStream().anyMatch(arg_0 -> ((ImmutableSet)newVariables).contains(arg_0))));
    }

    protected abstract IQTree applyFreshRenaming(InjectiveVar2VarSubstitution var1, boolean var2);

    protected abstract IQTree applyRegularDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> var1, Optional<ImmutableExpression> var2);

    private Optional<InjectiveVar2VarSubstitution> extractFreshRenaming(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) {
        return this.iqTreeTools.extractFreshRenaming(descendingSubstitution, this.getVariables());
    }

    @Override
    public final void validate() throws InvalidIntermediateQueryException {
        if (!this.hasBeenSuccessfullyValidate) {
            this.validateNode();
            this.children.forEach(IQTree::validate);
            this.hasBeenSuccessfullyValidate = true;
        }
    }

    protected abstract void validateNode() throws InvalidIntermediateQueryException;

    @Override
    public synchronized VariableNullability getVariableNullability() {
        VariableNullability variableNullability = this.treeCache.getVariableNullability();
        if (variableNullability != null) {
            return variableNullability;
        }
        variableNullability = this.computeVariableNullability();
        this.treeCache.setVariableNullability(variableNullability);
        return variableNullability;
    }

    protected abstract VariableNullability computeVariableNullability();

    protected IQTreeCache getTreeCache() {
        return this.treeCache;
    }

    @Override
    public synchronized ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions() {
        ImmutableSet<ImmutableSubstitution<NonVariableTerm>> possibleVariableDefinitions = this.treeCache.getPossibleVariableDefinitions();
        if (possibleVariableDefinitions == null) {
            possibleVariableDefinitions = this.computePossibleVariableDefinitions();
            this.treeCache.setPossibleVariableDefinitions(possibleVariableDefinitions);
        }
        return possibleVariableDefinitions;
    }

    protected abstract ImmutableSet<ImmutableSubstitution<NonVariableTerm>> computePossibleVariableDefinitions();

    @Override
    public synchronized ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints() {
        ImmutableSet<ImmutableSet<Variable>> uniqueConstraints = this.treeCache.getUniqueConstraints();
        if (uniqueConstraints == null) {
            uniqueConstraints = this.computeUniqueConstraints();
            this.treeCache.setUniqueConstraints(uniqueConstraints);
        }
        return uniqueConstraints;
    }

    protected abstract ImmutableSet<ImmutableSet<Variable>> computeUniqueConstraints();

    @Override
    public synchronized ImmutableSet<Variable> getNotInternallyRequiredVariables() {
        ImmutableSet<Variable> notInternallyRequiredVariables = this.treeCache.getNotInternallyRequiredVariables();
        if (notInternallyRequiredVariables != null) {
            return notInternallyRequiredVariables;
        }
        notInternallyRequiredVariables = this.computeNotInternallyRequiredVariables();
        this.treeCache.setNotInternallyRequiredVariables(notInternallyRequiredVariables);
        return notInternallyRequiredVariables;
    }

    protected abstract ImmutableSet<Variable> computeNotInternallyRequiredVariables();

    @Override
    public boolean isDistinct() {
        Boolean isDistinct = this.treeCache.isDistinct();
        if (isDistinct == null) {
            isDistinct = this.computeIsDistinct();
            this.treeCache.setIsDistinct(isDistinct);
        }
        return isDistinct;
    }

    protected abstract boolean computeIsDistinct();
}

