/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.ForeignKeyConstraintImpl;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractDatabaseRelationDefinition
extends AbstractRelationDefinition
implements DatabaseRelationDefinition {
    private final RelationID id;
    private final ImmutableSet<RelationID> allIds;
    private UniqueConstraint primaryKey;
    private final List<UniqueConstraint> uniqueConstraints = new LinkedList<UniqueConstraint>();
    private final List<FunctionalDependency> otherFunctionalDependencies = new ArrayList<FunctionalDependency>();
    private final List<ForeignKeyConstraint> foreignKeys = new ArrayList<ForeignKeyConstraint>();

    AbstractDatabaseRelationDefinition(ImmutableList<RelationID> allIds, RelationDefinition.AttributeListBuilder builder) {
        super(((RelationID)allIds.get(0)).getSQLRendering(), builder);
        this.id = (RelationID)allIds.get(0);
        this.allIds = ImmutableSet.copyOf(allIds);
    }

    @Override
    @JsonProperty(value="name")
    @JsonSerialize(using=RelationIDImpl.RelationIDSerializer.class)
    public RelationID getID() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public ImmutableSet<RelationID> getAllIDs() {
        return this.allIds;
    }

    @Override
    public ImmutableList<UniqueConstraint> getUniqueConstraints() {
        return ImmutableList.copyOf(this.uniqueConstraints);
    }

    @Override
    public void addFunctionalDependency(FunctionalDependency constraint) {
        if (constraint instanceof UniqueConstraint) {
            UniqueConstraint uc = (UniqueConstraint)constraint;
            if (uc.isPrimaryKey()) {
                if (this.primaryKey != null) {
                    throw new IllegalArgumentException("Duplicate PK " + this.primaryKey + " " + uc);
                }
                this.primaryKey = uc;
            }
            this.uniqueConstraints.add(uc);
        } else {
            this.otherFunctionalDependencies.add(constraint);
        }
    }

    @Override
    public ImmutableList<FunctionalDependency> getOtherFunctionalDependencies() {
        return ImmutableList.copyOf(this.otherFunctionalDependencies);
    }

    @Override
    @JsonIgnore
    public Optional<UniqueConstraint> getPrimaryKey() {
        return Optional.ofNullable(this.primaryKey);
    }

    @Override
    public void addForeignKeyConstraint(ForeignKeyConstraint fk) {
        this.foreignKeys.add(fk);
    }

    @Override
    @JsonSerialize(contentUsing=ForeignKeyConstraintImpl.ForeignKeyConstraintSerializer.class)
    public ImmutableList<ForeignKeyConstraint> getForeignKeys() {
        return ImmutableList.copyOf(this.foreignKeys);
    }
}

