/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLIRISafeEncoder {
    private static final Logger log = LoggerFactory.getLogger(R2RMLIRISafeEncoder.class);
    public static final ImmutableMap<String, String> TABLE = ImmutableMap.builder().put((Object)"%25", (Object)"%").put((Object)"%20", (Object)" ").put((Object)"%21", (Object)"!").put((Object)"%22", (Object)"\"").put((Object)"%23", (Object)"#").put((Object)"%24", (Object)"$").put((Object)"%26", (Object)"&").put((Object)"%27", (Object)"'").put((Object)"%28", (Object)"(").put((Object)"%29", (Object)")").put((Object)"%2A", (Object)"*").put((Object)"%2B", (Object)"+").put((Object)"%2C", (Object)",").put((Object)"%2F", (Object)"/").put((Object)"%3A", (Object)":").put((Object)"%3B", (Object)";").put((Object)"%3C", (Object)"<").put((Object)"%3D", (Object)"=").put((Object)"%3E", (Object)">").put((Object)"%3F", (Object)"?").put((Object)"%40", (Object)"@").put((Object)"%5B", (Object)"[").put((Object)"%5C", (Object)"\\").put((Object)"%5D", (Object)"]").put((Object)"%5E", (Object)"^").put((Object)"%60", (Object)"`").put((Object)"%7B", (Object)"{").put((Object)"%7C", (Object)"|").put((Object)"%7D", (Object)"}").build();

    public static String encode(String pe) {
        for (Map.Entry e : TABLE.entrySet()) {
            pe = pe.replace((CharSequence)e.getValue(), (CharSequence)e.getKey());
        }
        return pe;
    }

    public static String decode(String encodedURI) {
        int length = encodedURI.length();
        StringBuilder strBuilder = new StringBuilder(length + 20);
        char[] codeBuffer = new char[3];
        for (int i = 0; i < length; ++i) {
            char c = encodedURI.charAt(i);
            if (c != '%') {
                strBuilder.append(c);
                continue;
            }
            codeBuffer[0] = 37;
            codeBuffer[1] = encodedURI.charAt(i + 1);
            codeBuffer[2] = encodedURI.charAt(i + 2);
            String code = String.copyValueOf(codeBuffer);
            String rep = (String)TABLE.get((Object)code);
            if (rep != null) {
                strBuilder.append(rep);
            } else {
                log.warn("Error decoding an encoded URI from the query. Problematic code: {}\nProblematic URI: {}", (Object)code, (Object)encodedURI);
                strBuilder.append(codeBuffer);
            }
            i += 2;
        }
        return strBuilder.toString();
    }
}

