/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import it.unibz.inf.ontop.com.google.common.base.Joiner;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.substitution.impl.AbstractImmutableSubstitutionImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Var2VarSubstitutionImpl
extends AbstractImmutableSubstitutionImpl<Variable>
implements Var2VarSubstitution {
    private final ImmutableMap<Variable, Variable> map;

    protected Var2VarSubstitutionImpl(Map<Variable, ? extends Variable> substitutionMap, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(atomFactory, termFactory, substitutionFactory);
        this.map = ImmutableMap.copyOf(substitutionMap);
    }

    @Override
    public Variable applyToVariable(Variable variable) {
        if (this.map.containsKey((Object)variable)) {
            return (Variable)this.map.get((Object)variable);
        }
        return variable;
    }

    @Override
    public Var2VarSubstitution getVar2VarFragment() {
        return this;
    }

    @Override
    public ImmutableSubstitution<GroundTerm> getGroundTermFragment() {
        return this.substitutionFactory.getSubstitution();
    }

    @Override
    public <T extends ImmutableTerm> Optional<ImmutableSubstitution<T>> applyToSubstitution(ImmutableSubstitution<T> substitution) {
        if (this.isEmpty()) {
            return Optional.of(substitution);
        }
        try {
            ImmutableMap newMap = ImmutableMap.copyOf(substitution.getImmutableMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Variable, ImmutableTerm>(this.applyToVariable((Variable)e.getKey()), this.applyToTerm((ImmutableTerm)e.getValue()))).distinct().filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> {
                throw new NotASubstitutionException();
            })));
            return Optional.of(this.substitutionFactory.getSubstitution(newMap));
        }
        catch (NotASubstitutionException e3) {
            return Optional.empty();
        }
    }

    @Override
    public Variable get(Variable var) {
        return (Variable)this.map.get((Object)var);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator("/").join(this.map);
    }

    @Override
    public ImmutableMap<Variable, Variable> getImmutableMap() {
        return this.map;
    }

    @Override
    public boolean isDefining(Variable variable) {
        return this.map.containsKey((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getDomain() {
        return this.map.keySet();
    }

    @Override
    protected ImmutableSubstitution<Variable> constructNewSubstitution(ImmutableMap<Variable, Variable> map) {
        return this.substitutionFactory.getVar2VarSubstitution(map);
    }

    @Override
    public Var2VarSubstitution composeWithVar2Var(Var2VarSubstitution g) {
        return this.substitutionFactory.getVar2VarSubstitution(this.composeRenaming(g).collect(ImmutableCollectors.toMap()));
    }

    @Override
    public NonGroundTerm applyToNonGroundTerm(NonGroundTerm term) {
        if (term instanceof Variable) {
            return this.applyToVariable((Variable)term);
        }
        return (NonGroundTerm)((Object)this.applyToFunctionalTerm((ImmutableFunctionalTerm)((Object)term)));
    }

    @Override
    public <T extends ImmutableTerm> T applyToTerm(T term) {
        return (T)super.apply(term);
    }

    protected Stream<Map.Entry<Variable, Variable>> composeRenaming(Var2VarSubstitution g) {
        ImmutableSet<Variable> gDomain = g.getDomain();
        Stream<Map.Entry> gEntryStream = g.getImmutableMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), this.applyToVariable((Variable)e.getValue())));
        Stream<Map.Entry> localEntryStream = this.getImmutableMap().entrySet().stream().filter(e -> !gDomain.contains(e.getKey()));
        return Stream.concat(gEntryStream, localEntryStream).filter(e -> !((Variable)e.getKey()).equals(e.getValue()));
    }

    private static class NotASubstitutionException
    extends RuntimeException {
        private NotASubstitutionException() {
        }
    }
}

