/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.ConversionException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.GroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.substitution.impl.AbstractProtoSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractImmutableSubstitutionImpl<T extends ImmutableTerm>
extends AbstractProtoSubstitution<T>
implements ImmutableSubstitution<T> {
    final AtomFactory atomFactory;
    final SubstitutionFactory substitutionFactory;

    protected AbstractImmutableSubstitutionImpl(AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(termFactory);
        this.atomFactory = atomFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public <P extends AtomPredicate> DataAtom<P> applyToDataAtom(DataAtom<P> atom) throws ConversionException {
        ImmutableList<ImmutableTerm> newArguments = this.apply(atom.getArguments());
        if (!newArguments.stream().allMatch(t -> t instanceof VariableOrGroundTerm)) {
            throw new ConversionException("The substitution applied to a DataAtom has  produced some non-VariableOrGroundTerm arguments " + newArguments);
        }
        return this.atomFactory.getDataAtom(atom.getPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)newArguments);
    }

    @Override
    public ImmutableMap<Integer, ? extends VariableOrGroundTerm> applyToArgumentMap(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap) throws ConversionException {
        ImmutableMap<Integer, ImmutableTerm> newArgumentMap = argumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.apply((ImmutableTerm)e.getValue())));
        if (!newArgumentMap.values().stream().allMatch(t -> t instanceof VariableOrGroundTerm)) {
            throw new ConversionException("The substitution applied to an argument map has  produced some non-VariableOrGroundTerm arguments " + newArgumentMap);
        }
        return newArgumentMap;
    }

    @Override
    public DistinctVariableOnlyDataAtom applyToDistinctVariableOnlyDataAtom(DistinctVariableOnlyDataAtom dataAtom) throws ConversionException {
        ImmutableList<ImmutableTerm> newArguments = this.apply(dataAtom.getArguments());
        if (!newArguments.stream().allMatch(t -> t instanceof Variable)) {
            throw new ConversionException("The substitution applied to a DistinctVariableOnlyDataAtom has  produced some non-Variable arguments " + newArguments);
        }
        ImmutableList<ImmutableTerm> variableArguments = newArguments;
        if (variableArguments.size() == ImmutableSet.copyOf(variableArguments).size()) {
            return this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)dataAtom.getPredicate(), (ImmutableList<Variable>)variableArguments);
        }
        throw new ConversionException("The substitution applied a DistinctVariableOnlyDataAtom has introduced redundant variables: " + newArguments);
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> composeWith(ImmutableSubstitution<? extends ImmutableTerm> f) {
        if (this.isEmpty()) {
            return f;
        }
        if (f.isEmpty()) {
            return this;
        }
        HashMap substitutionMap = new HashMap();
        for (Map.Entry gEntry : f.getImmutableMap().entrySet()) {
            substitutionMap.put(gEntry.getKey(), this.apply((ImmutableTerm)gEntry.getValue()));
        }
        for (Map.Entry localEntry : this.getImmutableMap().entrySet()) {
            Variable localVariable = (Variable)localEntry.getKey();
            if (substitutionMap.containsKey(localVariable)) continue;
            substitutionMap.put(localVariable, (ImmutableTerm)localEntry.getValue());
        }
        return this.substitutionFactory.getSubstitution(substitutionMap.entrySet().stream().filter(entry -> !((Variable)entry.getKey()).equals(entry.getValue())).collect(ImmutableCollectors.toMap()));
    }

    @Override
    public ImmutableSubstitution<T> composeWith2(ImmutableSubstitution<? extends T> g) {
        return this.composeWith(g);
    }

    protected Optional<ImmutableMap<Variable, T>> computeUnionMap(ImmutableSubstitution<T> otherSubstitution) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.putAll(this.getImmutableMap());
        ImmutableMap otherMap = otherSubstitution.getImmutableMap();
        for (Variable otherVariable : otherMap.keySet()) {
            ImmutableTerm otherTerm = (ImmutableTerm)otherMap.get((Object)otherVariable);
            if (this.isDefining(otherVariable) && !this.get(otherVariable).equals(otherTerm)) {
                return Optional.empty();
            }
            mapBuilder.put((Object)otherVariable, (Object)otherTerm);
        }
        return Optional.of(mapBuilder.build());
    }

    @Override
    public Optional<ImmutableSubstitution<T>> union(ImmutableSubstitution<T> otherSubstitution) {
        if (otherSubstitution.isEmpty()) {
            return Optional.of(this);
        }
        if (this.isEmpty()) {
            return Optional.of(otherSubstitution);
        }
        Optional<ImmutableMap<Variable, T>> optionalMap = this.computeUnionMap(otherSubstitution);
        if (optionalMap.isPresent()) {
            ImmutableSubstitution<T> unionSubstitution = this.substitutionFactory.getSubstitution(optionalMap.get());
            return Optional.of(unionSubstitution);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ImmutableSubstitution<? extends ImmutableTerm>> unionHeterogeneous(ImmutableSubstitution<? extends ImmutableTerm> otherSubstitution) {
        if (otherSubstitution.isEmpty()) {
            return Optional.of(this);
        }
        if (this.isEmpty()) {
            return Optional.of(otherSubstitution);
        }
        ImmutableMap localMap = this.getImmutableMap();
        ImmutableSet otherEntrySet = otherSubstitution.getImmutableMap().entrySet();
        if (otherEntrySet.stream().filter(e -> localMap.containsKey(e.getKey())).anyMatch(e -> !((ImmutableTerm)localMap.get(e.getKey())).equals(e.getValue()))) {
            return Optional.empty();
        }
        ImmutableMap<Variable, ImmutableTerm> newMap = Stream.concat(localMap.entrySet().stream(), otherEntrySet.stream()).distinct().collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Optional.of(this.substitutionFactory.getSubstitution(newMap));
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> applyToTarget(ImmutableSubstitution<? extends ImmutableTerm> otherSubstitution) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ImmutableMap otherSubstitutionMap = otherSubstitution.getImmutableMap();
        for (Map.Entry otherEntry : otherSubstitutionMap.entrySet()) {
            ImmutableTerm newValue = this.apply((ImmutableTerm)otherEntry.getValue());
            if (((Variable)otherEntry.getKey()).equals(newValue)) continue;
            mapBuilder.put(otherEntry.getKey(), (Object)newValue);
        }
        return this.substitutionFactory.getSubstitution(mapBuilder.build());
    }

    public boolean equals(Object other) {
        if (other instanceof ImmutableSubstitution) {
            return this.getImmutableMap().equals(((ImmutableSubstitution)other).getImmutableMap());
        }
        return false;
    }

    protected abstract ImmutableSubstitution<T> constructNewSubstitution(ImmutableMap<Variable, T> var1);

    @Override
    public ImmutableSubstitution<T> orientate(ImmutableList<Variable> priorityVariables) {
        if (priorityVariables.isEmpty() || this.isEmpty()) {
            return this;
        }
        ImmutableMap localMap = this.getImmutableMap();
        ImmutableSet<Variable> domain = this.getDomain();
        if (localMap.values().stream().flatMap(ImmutableTerm::getVariableStream).anyMatch(arg_0 -> domain.contains(arg_0))) {
            throw new UnsupportedOperationException("The orientate() method requires the domain and the range to be disjoint");
        }
        ImmutableMap<Variable, Variable> renamingMap = localMap.entrySet().stream().filter(e -> e.getValue() instanceof Variable).filter(e -> {
            int replacedVariableIndex = priorityVariables.indexOf(e.getKey());
            int targetVariableIndex = priorityVariables.indexOf(e.getValue());
            return replacedVariableIndex >= 0 && (targetVariableIndex < 0 || replacedVariableIndex < targetVariableIndex);
        }).collect(ImmutableCollectors.toMap(e -> (Variable)e.getValue(), Map.Entry::getKey, (v1, v2) -> priorityVariables.indexOf(v1) <= priorityVariables.indexOf(v2) ? v1 : v2));
        if (renamingMap.isEmpty()) {
            return this;
        }
        Var2VarSubstitution renamingSubstitution = this.substitutionFactory.getVar2VarSubstitution(renamingMap);
        ImmutableMap<Variable, ImmutableTerm> orientedMap = Stream.concat(localMap.entrySet().stream().filter(e -> !Optional.ofNullable(renamingMap.get(e.getValue())).filter(newValue -> newValue.equals(e.getKey())).isPresent()), renamingMap.entrySet().stream().map(e -> e)).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> renamingSubstitution.applyToTerm((ImmutableTerm)e.getValue())));
        return this.constructNewSubstitution(orientedMap);
    }

    @Override
    public Optional<ImmutableExpression> convertIntoBooleanExpression() {
        return this.convertIntoBooleanExpression(this);
    }

    @Override
    public ImmutableSubstitution<T> reduceDomainToIntersectionWith(ImmutableSet<Variable> restrictingDomain) {
        if (restrictingDomain.containsAll(this.getDomain())) {
            return this;
        }
        return this.substitutionFactory.getSubstitution(this.getImmutableMap().entrySet().stream().filter(e -> restrictingDomain.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> simplifyValues(VariableNullability variableNullability) {
        return this.simplifyValues(Optional.of(variableNullability));
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> simplifyValues() {
        return this.simplifyValues(Optional.empty());
    }

    public ImmutableSubstitution<ImmutableTerm> simplifyValues(Optional<VariableNullability> variableNullability) {
        return this.substitutionFactory.getSubstitution(this.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> variableNullability.map(n -> ((ImmutableTerm)e.getValue()).simplify((VariableNullability)n)).orElseGet(() -> ((ImmutableTerm)e.getValue()).simplify()))));
    }

    protected Optional<ImmutableExpression> convertIntoBooleanExpression(ImmutableSubstitution<? extends ImmutableTerm> substitution) {
        ArrayList<ImmutableExpression> equalities = new ArrayList<ImmutableExpression>();
        for (Map.Entry entry : substitution.getImmutableMap().entrySet()) {
            equalities.add(this.termFactory.getStrictEquality((ImmutableTerm)entry.getKey(), (ImmutableTerm)entry.getValue(), new ImmutableTerm[0]));
        }
        switch (equalities.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(equalities.get(0));
            }
        }
        Iterator equalityIterator = equalities.iterator();
        ImmutableExpression aggregateExpression = (ImmutableExpression)equalityIterator.next();
        while (equalityIterator.hasNext()) {
            aggregateExpression = this.termFactory.getConjunction(aggregateExpression, (ImmutableExpression)equalityIterator.next());
        }
        return Optional.of(aggregateExpression);
    }

    @Override
    public ImmutableSubstitution<VariableOrGroundTerm> getVariableOrGroundTermFragment() {
        ImmutableMap<Variable, VariableOrGroundTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof VariableOrGroundTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (VariableOrGroundTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    @Override
    public ImmutableSubstitution<NonGroundFunctionalTerm> getNonGroundFunctionalTermFragment() {
        ImmutableMap<Variable, NonGroundFunctionalTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof NonGroundFunctionalTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (NonGroundFunctionalTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    @Override
    public ImmutableSubstitution<GroundFunctionalTerm> getGroundFunctionalTermFragment() {
        ImmutableMap<Variable, GroundFunctionalTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof GroundFunctionalTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (GroundFunctionalTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    @Override
    public ImmutableSubstitution<NonFunctionalTerm> getNonFunctionalTermFragment() {
        ImmutableMap<Variable, NonFunctionalTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof NonFunctionalTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (NonFunctionalTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    @Override
    public ImmutableSubstitution<ImmutableFunctionalTerm> getFunctionalTermFragment() {
        ImmutableMap<Variable, ImmutableFunctionalTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof ImmutableFunctionalTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableFunctionalTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    @Override
    public ImmutableSubstitution<NonVariableTerm> getNonVariableTermFragment() {
        ImmutableMap<Variable, NonVariableTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof NonVariableTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (NonVariableTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }
}

