/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import java.util.Optional;
import javax.annotation.Nullable;

public class IncrementalEvaluationImpl
implements IncrementalEvaluation {
    private static final IncrementalEvaluation SAME_EXPRESSION_RESULT = new IncrementalEvaluationImpl(IncrementalEvaluation.Status.SAME_EXPRESSION);
    private static final IncrementalEvaluation IS_NULL_RESULT = new IncrementalEvaluationImpl(IncrementalEvaluation.Status.IS_NULL);
    private static final IncrementalEvaluation IS_TRUE_RESULT;
    private static final IncrementalEvaluation IS_FALSE_RESULT;
    @Nullable
    private final ImmutableExpression simplifiedExpression;
    private final IncrementalEvaluation.Status status;

    private IncrementalEvaluationImpl(ImmutableExpression expression) {
        this.simplifiedExpression = expression;
        this.status = IncrementalEvaluation.Status.SIMPLIFIED_EXPRESSION;
    }

    private IncrementalEvaluationImpl(IncrementalEvaluation.Status status) {
        if (status == IncrementalEvaluation.Status.SIMPLIFIED_EXPRESSION) {
            throw new IllegalArgumentException("Use a different construction for SIMPLIFIED EXPRESSION");
        }
        this.simplifiedExpression = null;
        this.status = status;
    }

    @Override
    public Optional<ImmutableExpression> getNewExpression() {
        return Optional.ofNullable(this.simplifiedExpression);
    }

    @Override
    public IncrementalEvaluation.Status getStatus() {
        return this.status;
    }

    public static IncrementalEvaluation declareSimplifiedExpression(ImmutableExpression simplifiedExpression) {
        return new IncrementalEvaluationImpl(simplifiedExpression);
    }

    public static IncrementalEvaluation declareSameExpression() {
        return SAME_EXPRESSION_RESULT;
    }

    public static IncrementalEvaluation declareIsNull() {
        return IS_NULL_RESULT;
    }

    public static IncrementalEvaluation declareIsFalse() {
        return IS_FALSE_RESULT;
    }

    public static IncrementalEvaluation declareIsTrue() {
        return IS_TRUE_RESULT;
    }

    static {
        IS_FALSE_RESULT = new IncrementalEvaluationImpl(IncrementalEvaluation.Status.IS_FALSE);
        IS_TRUE_RESULT = new IncrementalEvaluationImpl(IncrementalEvaluation.Status.IS_TRUE);
    }
}

