/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.TermType;
import javax.annotation.Nonnull;

public abstract class SPARQLLikeFunctionSymbolImpl
extends FunctionSymbolImpl {
    protected SPARQLLikeFunctionSymbolImpl(@Nonnull String name, @Nonnull ImmutableList<TermType> expectedBaseTypes) {
        super(name, expectedBaseTypes);
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    protected boolean isRDFFunctionalTerm(ImmutableTerm term) {
        return term instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term).getFunctionSymbol() instanceof RDFTermFunctionSymbol;
    }

    protected ImmutableTerm extractRDFTermTypeTerm(ImmutableTerm rdfTerm, TermFactory termFactory) {
        if (this.isRDFFunctionalTerm(rdfTerm)) {
            return ((ImmutableFunctionalTerm)rdfTerm).getTerm(1);
        }
        if (rdfTerm instanceof RDFConstant) {
            return termFactory.getRDFTermTypeConstant(((RDFConstant)rdfTerm).getType());
        }
        if (rdfTerm instanceof Constant && rdfTerm.isNull()) {
            return termFactory.getNullConstant();
        }
        throw new IllegalArgumentException("Was expecting a isRDFFunctionalTerm or an RDFConstant or NULL");
    }

    protected ImmutableTerm extractLexicalTerm(ImmutableTerm rdfTerm, TermFactory termFactory) {
        if (this.isRDFFunctionalTerm(rdfTerm)) {
            return ((ImmutableFunctionalTerm)rdfTerm).getTerm(0);
        }
        if (rdfTerm instanceof RDFConstant) {
            return termFactory.getDBStringConstant(((RDFConstant)rdfTerm).getValue());
        }
        if (rdfTerm instanceof Constant && rdfTerm.isNull()) {
            return termFactory.getNullConstant();
        }
        throw new IllegalArgumentException("Was expecting a isRDFFunctionalTerm or an RDFConstant or NULL");
    }
}

