/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public abstract class ReduciblePositiveAritySPARQLFunctionSymbolImpl
extends SPARQLFunctionSymbolImpl {
    protected ReduciblePositiveAritySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull ImmutableList<TermType> expectedBaseTypes) {
        super(functionSymbolName, functionIRI, expectedBaseTypes);
        if (expectedBaseTypes.isEmpty()) {
            throw new IllegalArgumentException("The arity must be >= 1");
        }
    }

    protected ReduciblePositiveAritySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull String officialName, @Nonnull ImmutableList<TermType> expectedBaseTypes) {
        super(functionSymbolName, officialName, expectedBaseTypes);
        if (expectedBaseTypes.isEmpty()) {
            throw new IllegalArgumentException("The arity must be >= 1");
        }
    }

    @Override
    protected final ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (!this.tolerateNulls() && newTerms.stream().anyMatch(t -> t instanceof Constant && t.isNull())) {
            return termFactory.getNullConstant();
        }
        if (newTerms.stream().allMatch(t -> this.isRDFFunctionalTerm((ImmutableTerm)t) || t instanceof Constant)) {
            ImmutableList typeTerms = (ImmutableList)newTerms.stream().map(t -> this.extractRDFTermTypeTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            ImmutableList subLexicalTerms = (ImmutableList)newTerms.stream().map(t -> this.extractLexicalTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            ImmutableExpression.Evaluation inputTypeErrorEvaluation = this.evaluateInputTypeError((ImmutableList<ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory, variableNullability);
            if (inputTypeErrorEvaluation.getValue().isPresent()) {
                switch (inputTypeErrorEvaluation.getValue().get()) {
                    case FALSE: {
                        return termFactory.getNullConstant();
                    }
                    case NULL: {
                        throw new MinorOntopInternalBugException("This evaluation (SPARQL type error on the arguments) should not produce a NULL");
                    }
                }
            }
            ImmutableTerm typeTerm = this.computeTypeTerm((ImmutableList<? extends ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory, variableNullability);
            ImmutableTerm lexicalTerm = this.computeLexicalTerm((ImmutableList<ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory, typeTerm);
            Optional<ImmutableExpression> condition = inputTypeErrorEvaluation.getExpression();
            return termFactory.getRDFFunctionalTerm(condition.map(c -> termFactory.getIfElseNull((ImmutableExpression)c, lexicalTerm)).orElse(lexicalTerm), condition.map(c -> termFactory.getIfElseNull((ImmutableExpression)c, typeTerm)).orElse(typeTerm)).simplify(variableNullability);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    protected ImmutableExpression.Evaluation evaluateInputTypeError(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList typeTestExpressions = (ImmutableList)IntStream.range(0, typeTerms.size()).boxed().map(i -> termFactory.getIsAExpression((ImmutableTerm)typeTerms.get(i.intValue()), (RDFTermType)this.getExpectedBaseType((int)i))).collect(ImmutableCollectors.toList());
        return termFactory.getConjunction((ImmutableList<ImmutableExpression>)typeTestExpressions).evaluate(variableNullability);
    }

    protected abstract ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> var1, ImmutableList<ImmutableTerm> var2, TermFactory var3, ImmutableTerm var4);

    protected abstract ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> var1, ImmutableList<ImmutableTerm> var2, TermFactory var3, VariableNullability var4);
}

