/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLLikeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import javax.annotation.Nonnull;

public class EBVSPARQLLikeFunctionSymbolImpl
extends SPARQLLikeFunctionSymbolImpl {
    private final RDFDatatype xsdBooleanType;

    protected EBVSPARQLLikeFunctionSymbolImpl(@Nonnull RDFDatatype rootDatatype, RDFDatatype xsdBooleanType) {
        super("SP_EBV", (ImmutableList<TermType>)ImmutableList.of((Object)rootDatatype));
        this.xsdBooleanType = xsdBooleanType;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.xsdBooleanType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected final ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (this.isRDFFunctionalTerm(newTerm) || newTerm instanceof Constant) {
            ImmutableTerm subTypeTerm;
            ImmutableTerm subLexicalTerm = this.extractLexicalTerm(newTerm, termFactory);
            ImmutableTerm lexicalTerm = this.computeLexicalTerm(subLexicalTerm, subTypeTerm = this.extractRDFTermTypeTerm(newTerm, termFactory), termFactory).simplify(variableNullability);
            if (lexicalTerm.equals(termFactory.getNullConstant())) {
                return lexicalTerm;
            }
            ImmutableTerm typeTerm = termFactory.getIfElseNull(termFactory.getDBIsNotNull(lexicalTerm), termFactory.getRDFTermTypeConstant(this.xsdBooleanType)).simplify(variableNullability);
            return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    protected ImmutableTerm computeLexicalTerm(ImmutableTerm subLexicalTerm, ImmutableTerm subTypeTerm, TermFactory termFactory) {
        return termFactory.getConversion2RDFLexical(termFactory.getLexicalEffectiveBooleanValue(subLexicalTerm, subTypeTerm), this.xsdBooleanType);
    }
}

