/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.Templates;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class ObjectStringTemplateFunctionSymbolImpl
extends FunctionSymbolImpl
implements ObjectStringTemplateFunctionSymbol {
    private final String template;
    private final DBTermType lexicalType;
    private final Pattern pattern;
    private final boolean isInjective;
    protected static final ImmutableList<Character> SOME_SAFE_SEPARATORS = ImmutableList.of((Object)Character.valueOf('/'), (Object)Character.valueOf('!'), (Object)Character.valueOf('$'), (Object)Character.valueOf('&'), (Object)Character.valueOf('\''), (Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object)Character.valueOf('*'), (Object)Character.valueOf('+'), (Object)Character.valueOf(','), (Object)Character.valueOf(';'), (Object)Character.valueOf('='), (Object[])new Character[]{Character.valueOf('#')});
    protected static final String PLACE_HOLDER = "{}";
    @Nullable
    private ImmutableList<DBConstant> templateConstants;

    protected ObjectStringTemplateFunctionSymbolImpl(String template, int arity, TypeFactory typeFactory) {
        super(template, ObjectStringTemplateFunctionSymbolImpl.createBaseTypes(arity, typeFactory));
        this.template = template;
        this.lexicalType = typeFactory.getDBTypeFactory().getDBStringType();
        this.templateConstants = null;
        this.pattern = ObjectStringTemplateFunctionSymbolImpl.extractPattern(template, true);
        this.isInjective = this.isInjective(arity, template);
    }

    protected boolean isInjective(int arity, String template) {
        if (arity < 2) {
            return true;
        }
        ImmutableList<String> intermediateStrings = ObjectStringTemplateFunctionSymbolImpl.extractIntermediateStrings(template);
        if (intermediateStrings.size() != arity - 1) {
            throw new IllegalArgumentException(String.format("The template %s is not matching the arity %d", template, arity));
        }
        return intermediateStrings.stream().allMatch(interm -> SOME_SAFE_SEPARATORS.stream().anyMatch(sep -> interm.indexOf(sep.charValue()) >= 0));
    }

    protected static ImmutableList<String> extractIntermediateStrings(String template) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int afterPlaceHolderIndex = template.indexOf(PLACE_HOLDER) + 2;
        int nextPlaceHolderIndex = template.indexOf(PLACE_HOLDER, afterPlaceHolderIndex);
        while (nextPlaceHolderIndex > 0) {
            builder.add((Object)template.substring(afterPlaceHolderIndex, nextPlaceHolderIndex));
            afterPlaceHolderIndex = nextPlaceHolderIndex + 2;
            nextPlaceHolderIndex = template.indexOf(PLACE_HOLDER, afterPlaceHolderIndex);
        }
        return builder.build();
    }

    private static ImmutableList<TermType> createBaseTypes(int arity, TypeFactory typeFactory) {
        RDFDatatype stringType = typeFactory.getXsdStringDatatype();
        return (ImmutableList)IntStream.range(0, arity).boxed().map(i -> stringType).collect(ImmutableCollectors.toList());
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.stream().filter(t -> t instanceof Constant).anyMatch(t -> ((Constant)t).isNull())) {
            return Optional.empty();
        }
        return Optional.of(TermTypeInference.declareTermType(this.lexicalType));
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().allMatch(t -> t instanceof DBConstant)) {
            ImmutableList values = (ImmutableList)newTerms.stream().map(t -> (DBConstant)t).map(c -> this.encodeParameter((DBConstant)c, termFactory, variableNullability)).collect(ImmutableCollectors.toList());
            return termFactory.getDBConstant(Templates.format(this.template, values), this.lexicalType);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    private String encodeParameter(DBConstant constant, TermFactory termFactory, VariableNullability variableNullability) {
        return Optional.of(termFactory.getR2RMLIRISafeEncodeFunctionalTerm(constant).simplify(variableNullability)).filter(t -> t instanceof DBConstant).map(t -> ((DBConstant)t).getValue()).orElseThrow(() -> new MinorOntopInternalBugException("Was expecting the getR2RMLIRISafeEncodeFunctionalTerm to simplify itself to a DBConstant when receving a DBConstant"));
    }

    protected ImmutableList<DBConstant> getTemplateConstants(TermFactory termFactory) {
        if (this.templateConstants == null) {
            String[] split = this.template.split("[{][}]");
            this.templateConstants = (ImmutableList)Stream.of(split).map(termFactory::getDBStringConstant).collect(ImmutableCollectors.toList());
        }
        return this.templateConstants;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.isInjective;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableList<DBConstant> templateCsts = this.getTemplateConstants(termFactory);
        ImmutableList termsToConcatenate = (ImmutableList)IntStream.range(0, templateCsts.size()).boxed().flatMap(i -> i < terms.size() ? Stream.of((ImmutableTerm)templateCsts.get(i.intValue()), termFactory.getR2RMLIRISafeEncodeFunctionalTerm((ImmutableTerm)terms.get(i.intValue())).simplify()) : Stream.of(templateCsts.get(i.intValue()))).collect(ImmutableCollectors.toList());
        DBConstant concatTerm = termsToConcatenate.isEmpty() ? termFactory.getDBStringConstant("") : (termsToConcatenate.size() == 1 ? (ImmutableTerm)termsToConcatenate.get(0) : termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)termsToConcatenate).simplify());
        return termConverter.apply(concatTerm);
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithFunctionalTerm(ImmutableList<? extends ImmutableTerm> terms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        String otherTemplate;
        FunctionSymbol otherFunctionSymbol = otherTerm.getFunctionSymbol();
        if (otherFunctionSymbol instanceof ObjectStringTemplateFunctionSymbol && !this.areCompatible(otherTemplate = ((ObjectStringTemplateFunctionSymbol)otherFunctionSymbol).getTemplate())) {
            return IncrementalEvaluation.declareIsFalse();
        }
        return super.evaluateStrictEqWithFunctionalTerm(terms, otherTerm, termFactory, variableNullability);
    }

    protected boolean areCompatible(String otherTemplate) {
        int otherPrefixLength;
        if (this.template.equals(otherTemplate)) {
            return true;
        }
        String prefix = ObjectStringTemplateFunctionSymbolImpl.extractPrefix(this.template);
        String otherPrefix = ObjectStringTemplateFunctionSymbolImpl.extractPrefix(otherTemplate);
        int prefixLength = prefix.length();
        int minLength = Math.min(prefixLength, otherPrefixLength = otherPrefix.length());
        if (!prefix.substring(0, minLength).equals(otherPrefix.substring(0, minLength))) {
            return false;
        }
        String remainingTemplate = this.template.substring(minLength);
        String otherRemainingTemplate = otherTemplate.substring(minLength);
        Pattern subPattern = ObjectStringTemplateFunctionSymbolImpl.extractPattern(remainingTemplate, false);
        return subPattern.matcher(otherRemainingTemplate).find();
    }

    protected static Pattern extractPattern(String template, boolean surroundWithParentheses) {
        String tmpPlaceholder = UUID.randomUUID().toString().replace("-", "");
        String safeTemplate = ObjectStringTemplateFunctionSymbolImpl.makeRegexSafe(template.replace(PLACE_HOLDER, tmpPlaceholder));
        String notSeparator = SOME_SAFE_SEPARATORS.stream().map(Object::toString).map(ObjectStringTemplateFunctionSymbolImpl::makeRegexSafe).reduce("[^", (c1, c2) -> c1 + c2, (c1, c2) -> c1 + c2) + "]*";
        String replacement = surroundWithParentheses ? "(" + notSeparator + ")" : notSeparator;
        String patternString = "^" + safeTemplate.replace(tmpPlaceholder, replacement) + "$";
        return Pattern.compile(patternString);
    }

    private static String makeRegexSafe(String s) {
        return s.replaceAll("[\\<\\(\\[\\{\\\\\\^\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>]", "\\\\$0");
    }

    private static String extractPrefix(String template) {
        int index = template.indexOf("{");
        return index >= 0 ? template.substring(0, index) : template;
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        String otherValue = otherTerm.getValue();
        if (this.isInjective(terms, variableNullability, termFactory)) {
            Matcher matcher = this.pattern.matcher(otherTerm.getValue());
            if (matcher.find()) {
                ImmutableList subConstants = (ImmutableList)IntStream.range(0, this.getArity()).boxed().map(i -> matcher.group(i + 1)).map(termFactory::getDBStringConstant).collect(ImmutableCollectors.toList());
                ImmutableExpression newExpression = termFactory.getConjunction(IntStream.range(0, this.getArity()).boxed().map(i -> termFactory.getStrictEquality(termFactory.getR2RMLIRISafeEncodeFunctionalTerm((ImmutableTerm)terms.get(i.intValue())), (ImmutableTerm)subConstants.get(i.intValue()), new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("An ObjectStringTemplateFunctionSymbolImpl is expected to have a non-null arity"));
                return newExpression.evaluate(variableNullability, true);
            }
            return IncrementalEvaluation.declareIsFalse();
        }
        if (!this.areCompatible(otherValue)) {
            return IncrementalEvaluation.declareIsFalse();
        }
        return super.evaluateStrictEqWithNonNullConstant(terms, otherTerm, termFactory, variableNullability);
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return true;
    }
}

