/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.FunctionalTermSimplification;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractArgDependentTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class NullIfDBFunctionSymbolImpl
extends AbstractArgDependentTypedDBFunctionSymbol {
    protected static final String NULLIF_STR = "NULLIF";
    private final DBFunctionSymbolSerializer serializer;

    protected NullIfDBFunctionSymbolImpl(String name, DBTermType rootDBTermType, DBFunctionSymbolSerializer serializer) {
        super(name, (ImmutableList<TermType>)ImmutableList.of((Object)rootDBTermType, (Object)rootDBTermType));
        this.serializer = serializer;
    }

    protected NullIfDBFunctionSymbolImpl(DBTermType rootDBTermType) {
        this(NULLIF_STR, rootDBTermType, Serializers.getRegularSerializer(NULLIF_STR));
    }

    @Override
    protected Stream<? extends ImmutableTerm> extractPossibleValues(ImmutableList<? extends ImmutableTerm> terms) {
        return Stream.of(terms.get(0));
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return false;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializer.getNativeDBString(terms, termConverter, termFactory);
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm term1 = (ImmutableTerm)newTerms.get(0);
        ImmutableTerm term2 = (ImmutableTerm)newTerms.get(1);
        if (term1.isNull() || term2.isNull()) {
            return term1;
        }
        if (term1.equals(term2)) {
            return termFactory.getNullConstant();
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        Map.Entry<ImmutableTerm, Stream<ImmutableTerm>> decomposition = this.decomposeNullIfHierarchy(terms);
        ImmutableTerm firstTerm = decomposition.getKey();
        Stream<ImmutableTerm> secondTerms = decomposition.getValue();
        ImmutableExpression conjunction = termFactory.getConjunction(Stream.concat(Stream.of(termFactory.getDBIsNotNull(firstTerm)), secondTerms.map(term2 -> termFactory.getDisjunction(termFactory.getDBIsNull((ImmutableTerm)term2), termFactory.getDBNot(termFactory.getDBNonStrictDefaultEquality(firstTerm, (ImmutableTerm)term2)))))).orElseThrow(() -> new MinorOntopInternalBugException("Was expecting to have at least one second term"));
        return conjunction.evaluate(variableNullability, true);
    }

    protected Map.Entry<ImmutableTerm, Stream<ImmutableTerm>> decomposeNullIfHierarchy(ImmutableList<? extends ImmutableTerm> terms) {
        ImmutableTerm term1 = (ImmutableTerm)terms.get(0);
        ImmutableTerm term2 = (ImmutableTerm)terms.get(1);
        if (term1 instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term1).getFunctionSymbol() instanceof NullIfDBFunctionSymbolImpl) {
            Map.Entry<ImmutableTerm, Stream<ImmutableTerm>> subDecomposition = this.decomposeNullIfHierarchy(((ImmutableFunctionalTerm)term1).getTerms());
            return Maps.immutableEntry((Object)subDecomposition.getKey(), Stream.concat(Stream.of(term2), subDecomposition.getValue()));
        }
        return Maps.immutableEntry((Object)term1, Stream.of(term2));
    }

    @Override
    public FunctionalTermSimplification simplifyAsGuaranteedToBeNonNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        ImmutableTerm firstTerm = (ImmutableTerm)terms.get(0);
        if (firstTerm instanceof Variable) {
            return FunctionalTermSimplification.create(firstTerm, (ImmutableSet<Variable>)ImmutableSet.of((Object)((Variable)firstTerm)));
        }
        if (firstTerm instanceof ImmutableFunctionalTerm) {
            return ((ImmutableFunctionalTerm)firstTerm).simplifyAsGuaranteedToBeNonNull();
        }
        return FunctionalTermSimplification.create(firstTerm, (ImmutableSet<Variable>)ImmutableSet.of());
    }
}

