/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBTypeConversionFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractTimestampISONormFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;
import java.util.function.Function;

public class AbstractTimestampISODenormFunctionSymbol
extends AbstractDBTypeConversionFunctionSymbolImpl {
    private static final String CAST_TEMPLATE = "CAST(%s AS %s)";
    private final DBTermType dbStringType;

    protected AbstractTimestampISODenormFunctionSymbol(DBTermType timestampType, DBTermType dbStringType) {
        super("isoTimestampDenorm", dbStringType, timestampType);
        this.dbStringType = dbStringType;
    }

    @Override
    public Optional<DBTermType> getInputType() {
        return Optional.of(this.dbStringType);
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return true;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermFromFunctionalTerm(ImmutableFunctionalTerm subTerm, TermFactory termFactory, VariableNullability variableNullability) {
        FunctionSymbol subTermFunctionSymbol = subTerm.getFunctionSymbol();
        if (subTermFunctionSymbol instanceof AbstractTimestampISONormFunctionSymbol) {
            DBTermType targetType = this.getTargetType();
            ImmutableTerm subSubTerm = subTerm.getTerm(0);
            return ((AbstractTimestampISONormFunctionSymbol)subTermFunctionSymbol).getInputType().filter(t -> !t.equals(targetType)).map(t -> termFactory.getDBCastFunctionalTerm((DBTermType)t, targetType, subSubTerm)).orElse(subSubTerm);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)subTerm));
    }

    @Override
    protected ImmutableTerm convertDBConstant(DBConstant constant, TermFactory termFactory) {
        String newString = constant.getValue().replace("T", " ").replace("Z", "+00:00");
        return termFactory.getDBConstant(newString, this.getTargetType());
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableFunctionalTerm replaceTTerm = termFactory.getDBReplace((ImmutableTerm)terms.get(0), termFactory.getDBStringConstant("T"), termFactory.getDBStringConstant(" "));
        ImmutableFunctionalTerm newTerm = termFactory.getDBReplace(replaceTTerm, termFactory.getDBStringConstant("Z"), termFactory.getDBStringConstant("+00:00"));
        return String.format(CAST_TEMPLATE, termConverter.apply(newTerm), this.getTargetType().getCastName());
    }
}

