/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.atom.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public abstract class RDFAtomPredicateImpl
extends AtomPredicateImpl
implements RDFAtomPredicate {
    private final int subjectIndex;
    private final int propertyIndex;
    private final int objectIndex;
    private final RDFTermTypeConstant iriType;
    private final RDF rdfFactory;

    protected RDFAtomPredicateImpl(String name, ImmutableList<TermType> expectedBaseTypes, int subjectIndex, int propertyIndex, int objectIndex, RDFTermTypeConstant iriType, RDF rdfFactory) {
        super(name, expectedBaseTypes);
        this.subjectIndex = subjectIndex;
        this.propertyIndex = propertyIndex;
        this.objectIndex = objectIndex;
        this.rdfFactory = rdfFactory;
        this.iriType = iriType;
        if (subjectIndex >= expectedBaseTypes.size()) {
            throw new IllegalArgumentException("subjectIndex exceeds the arity");
        }
        if (propertyIndex >= expectedBaseTypes.size()) {
            throw new IllegalArgumentException("propertyIndex exceeds the arity");
        }
        if (objectIndex >= expectedBaseTypes.size()) {
            throw new IllegalArgumentException("objectIndex exceeds the arity");
        }
    }

    @Override
    public Optional<IRI> getClassIRI(ImmutableList<? extends ImmutableTerm> atomArguments) {
        if (atomArguments.size() != this.getArity()) {
            throw new IllegalArgumentException("The given arguments do not match with the expected arity");
        }
        return this.getPropertyIRI(atomArguments).filter(i -> i.equals((Object)it.unibz.inf.ontop.model.vocabulary.RDF.TYPE)).flatMap(i -> this.extractIRI((ImmutableTerm)atomArguments.get(this.objectIndex)));
    }

    @Override
    public Optional<IRI> getPropertyIRI(ImmutableList<? extends ImmutableTerm> atomArguments) {
        if (atomArguments.size() != this.getArity()) {
            throw new IllegalArgumentException("The given arguments do not match with the expected arity");
        }
        return this.extractIRI((ImmutableTerm)atomArguments.get(this.propertyIndex));
    }

    @Override
    public Optional<IRI> getPredicateIRI(ImmutableList<? extends ImmutableTerm> atomArguments) {
        return this.getPropertyIRI(atomArguments).flatMap(i -> i.equals((Object)it.unibz.inf.ontop.model.vocabulary.RDF.TYPE) ? this.extractIRI((ImmutableTerm)atomArguments.get(this.objectIndex)) : Optional.of(i));
    }

    @Override
    public <T extends ImmutableTerm> T getSubject(ImmutableList<T> atomArguments) {
        return (T)((ImmutableTerm)atomArguments.get(this.subjectIndex));
    }

    @Override
    public <T extends ImmutableTerm> T getProperty(ImmutableList<T> atomArguments) {
        return (T)((ImmutableTerm)atomArguments.get(this.propertyIndex));
    }

    @Override
    public <T extends ImmutableTerm> T getObject(ImmutableList<T> atomArguments) {
        return (T)((ImmutableTerm)atomArguments.get(this.objectIndex));
    }

    protected Optional<IRI> extractIRI(ImmutableTerm term) {
        if (term instanceof IRIConstant) {
            return Optional.of(((IRIConstant)term).getIRI());
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            return Optional.of(functionalTerm).filter(f -> f.getFunctionSymbol() instanceof RDFTermFunctionSymbol).filter(f -> f.getTerm(1).equals(this.iriType)).map(f -> f.getTerm(0)).filter(t -> t instanceof DBConstant).map(t -> this.rdfFactory.createIRI(((DBConstant)t).getValue()));
        }
        return Optional.empty();
    }
}

