/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinLikeNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.LeftJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.ExpressionAndSubstitutionImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class LeftJoinNodeImpl
extends JoinLikeNodeImpl
implements LeftJoinNode {
    private static final String LEFT_JOIN_NODE_STR = "LJ";
    private final ConditionSimplifier conditionSimplifier;
    private final LeftJoinNormalizer ljNormalizer;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;
    private final CoreUtilsFactory coreUtilsFactory;

    @AssistedInject
    private LeftJoinNodeImpl(@Assisted Optional<ImmutableExpression> optionalJoinCondition, TermNullabilityEvaluator nullabilityEvaluator, SubstitutionFactory substitutionFactory, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, ConditionSimplifier conditionSimplifier, LeftJoinNormalizer ljNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreUtilsFactory coreUtilsFactory) {
        super(optionalJoinCondition, nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.conditionSimplifier = conditionSimplifier;
        this.ljNormalizer = ljNormalizer;
        this.variableNullabilityTools = variableNullabilityTools;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @AssistedInject
    private LeftJoinNodeImpl(@Assisted ImmutableExpression joiningCondition, TermNullabilityEvaluator nullabilityEvaluator, SubstitutionFactory substitutionFactory, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, ConditionSimplifier conditionSimplifier, LeftJoinNormalizer ljNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreUtilsFactory coreUtilsFactory) {
        super(Optional.of(joiningCondition), nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.conditionSimplifier = conditionSimplifier;
        this.ljNormalizer = ljNormalizer;
        this.variableNullabilityTools = variableNullabilityTools;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @AssistedInject
    private LeftJoinNodeImpl(TermNullabilityEvaluator nullabilityEvaluator, SubstitutionFactory substitutionFactory, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, ConditionSimplifier conditionSimplifier, LeftJoinNormalizer ljNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreUtilsFactory coreUtilsFactory) {
        super(Optional.empty(), nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.conditionSimplifier = conditionSimplifier;
        this.ljNormalizer = ljNormalizer;
        this.variableNullabilityTools = variableNullabilityTools;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public LeftJoinNode clone() {
        return new LeftJoinNodeImpl(this.getOptionalFilterCondition(), this.getNullabilityEvaluator(), this.substitutionFactory, this.termFactory, this.typeFactory, this.iqFactory, this.unificationTools, this.substitutionTools, this.conditionSimplifier, this.ljNormalizer, this.variableNullabilityTools, this.coreUtilsFactory);
    }

    @Override
    public LeftJoinNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public LeftJoinNode changeOptionalFilterCondition(Optional<ImmutableExpression> newOptionalFilterCondition) {
        return new LeftJoinNodeImpl(newOptionalFilterCondition, this.getNullabilityEvaluator(), this.substitutionFactory, this.termFactory, this.typeFactory, this.iqFactory, this.unificationTools, this.substitutionTools, this.conditionSimplifier, this.ljNormalizer, this.variableNullabilityTools, this.coreUtilsFactory);
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        QueryNode leftChild = query.getChild(this, BinaryOrderedOperatorNode.ArgumentPosition.LEFT).orElseThrow(() -> new InvalidIntermediateQueryException("A left child is required"));
        if (query.getVariables(leftChild).contains((Object)variable)) {
            return leftChild.isVariableNullable(query, variable);
        }
        QueryNode rightChild = query.getChild(this, BinaryOrderedOperatorNode.ArgumentPosition.RIGHT).orElseThrow(() -> new InvalidIntermediateQueryException("A right child is required"));
        if (!query.getVariables(rightChild).contains((Object)variable)) {
            throw new IllegalArgumentException("The variable " + variable + " is not projected by " + this);
        }
        return false;
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return node instanceof LeftJoinNode && ((LeftJoinNode)node).getOptionalFilterCondition().equals(this.getOptionalFilterCondition());
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return queryNode instanceof LeftJoinNode && this.getOptionalFilterCondition().equals(((LeftJoinNode)queryNode).getOptionalFilterCondition());
    }

    public String toString() {
        return LEFT_JOIN_NODE_STR + this.getOptionalFilterString();
    }

    @Override
    public VariableNullability getVariableNullability(IQTree leftChild, IQTree rightChild) {
        VariableNullability rightNullability = this.getOptionalFilterCondition().map(c -> this.variableNullabilityTools.updateWithFilter((ImmutableExpression)c, rightChild.getVariableNullability().getNullableGroups(), rightChild.getVariables())).orElseGet(rightChild::getVariableNullability);
        ImmutableSet rightSpecificVariables = Sets.difference(rightChild.getVariables(), leftChild.getVariables()).immutableCopy();
        ImmutableSet rightSelectedGroups = (ImmutableSet)rightNullability.getNullableGroups().stream().map(g -> (ImmutableSet)g.stream().filter(arg_0 -> ((ImmutableSet)rightSpecificVariables).contains(arg_0)).collect(ImmutableCollectors.toSet())).filter(g -> !g.isEmpty()).collect(ImmutableCollectors.toSet());
        ImmutableSet initiallyNonNullableRightSpecificGroup = (ImmutableSet)rightSpecificVariables.stream().filter(v -> !rightNullability.isPossiblyNullable((Variable)v)).collect(ImmutableCollectors.toSet());
        Stream<ImmutableSet> rightGroupStream = initiallyNonNullableRightSpecificGroup.isEmpty() ? rightSelectedGroups.stream() : Stream.concat(Stream.of(initiallyNonNullableRightSpecificGroup), rightSelectedGroups.stream());
        ImmutableSet nullableGroups = (ImmutableSet)Stream.concat(leftChild.getVariableNullability().getNullableGroups().stream(), rightGroupStream).collect(ImmutableCollectors.toSet());
        ImmutableSet scope = Sets.union(leftChild.getVariables(), rightChild.getVariables()).immutableCopy();
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, (ImmutableSet<Variable>)scope);
    }

    @Override
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree leftChild, IQTree rightChild) {
        ImmutableSet<ImmutableSubstitution<NonVariableTerm>> leftDefs = leftChild.getPossibleVariableDefinitions();
        ImmutableSet rightSpecificVariables = Sets.difference(rightChild.getVariables(), leftChild.getVariables()).immutableCopy();
        ImmutableSet rightDefs = (ImmutableSet)rightChild.getPossibleVariableDefinitions().stream().map(s -> s.reduceDomainToIntersectionWith((ImmutableSet<Variable>)rightSpecificVariables)).collect(ImmutableCollectors.toSet());
        if (leftDefs.isEmpty()) {
            return rightDefs;
        }
        if (rightDefs.isEmpty()) {
            return leftDefs;
        }
        return (ImmutableSet)leftDefs.stream().flatMap(l -> rightDefs.stream().map(r -> this.combine((ImmutableSubstitution<NonVariableTerm>)l, (ImmutableSubstitution<NonVariableTerm>)r))).collect(ImmutableCollectors.toSet());
    }

    private ImmutableSubstitution<NonVariableTerm> combine(ImmutableSubstitution<NonVariableTerm> l, ImmutableSubstitution<NonVariableTerm> r) {
        return l.union(r).orElseThrow(() -> new MinorOntopInternalBugException("Unexpected conflict between " + l + " and " + r));
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree leftChild, IQTree rightChild) {
        return transformer.transformLeftJoin(tree, this, leftChild, rightChild);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree leftChild, IQTree rightChild) {
        return visitor.visitLeftJoin(this, leftChild, rightChild);
    }

    @Override
    public IQTree normalizeForOptimization(IQTree initialLeftChild, IQTree initialRightChild, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        return this.ljNormalizer.normalizeForOptimization(this, initialLeftChild, initialRightChild, variableGenerator, currentIQProperties);
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree leftChild, IQTree rightChild, VariableGenerator variableGenerator) {
        IQTree liftedLeftChild;
        QueryNode leftChildRoot;
        if (leftChild.getVariables().contains((Object)variable) && (leftChildRoot = (liftedLeftChild = leftChild.liftIncompatibleDefinitions(variable, variableGenerator)).getRootNode()) instanceof UnionNode && ((UnionNode)leftChildRoot).hasAChildWithLiftableDefinition(variable, liftedLeftChild.getChildren())) {
            UnionNode newUnionNode = this.iqFactory.createUnionNode((ImmutableSet<Variable>)((ImmutableSet)Stream.of(leftChild, rightChild).flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet())));
            return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)((ImmutableList)liftedLeftChild.getChildren().stream().map(unionChild -> this.iqFactory.createBinaryNonCommutativeIQTree(this, (IQTree)unionChild, rightChild)).collect(ImmutableCollectors.toList())));
        }
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, leftChild, rightChild);
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree leftChild, IQTree rightChild) {
        if (constraint.filter(c -> this.isRejectingRightSpecificNulls((ImmutableExpression)c, leftChild, rightChild)).isPresent() || this.containsEqualityRightSpecificVariable(descendingSubstitution, leftChild, rightChild)) {
            return this.transformIntoInnerJoinTree(leftChild, rightChild).applyDescendingSubstitution(descendingSubstitution, constraint);
        }
        IQTree updatedLeftChild = leftChild.applyDescendingSubstitution(descendingSubstitution, constraint);
        Optional<ImmutableExpression> initialExpression = this.getOptionalFilterCondition();
        if (initialExpression.isPresent()) {
            try {
                ConditionSimplifier.ExpressionAndSubstitution expressionAndCondition = this.applyDescendingSubstitutionToExpression(initialExpression.get(), descendingSubstitution, leftChild.getVariables(), rightChild.getVariables());
                ImmutableSubstitution<? extends VariableOrGroundTerm> rightDescendingSubstitution = expressionAndCondition.getSubstitution().composeWith2(descendingSubstitution);
                IQTree updatedRightChild = rightChild.applyDescendingSubstitution(rightDescendingSubstitution, Optional.empty());
                return updatedRightChild.isDeclaredAsEmpty() ? updatedLeftChild : this.iqFactory.createBinaryNonCommutativeIQTree(this.iqFactory.createLeftJoinNode(expressionAndCondition.getOptionalExpression()), updatedLeftChild, updatedRightChild);
            }
            catch (UnsatisfiableConditionException e) {
                return updatedLeftChild;
            }
        }
        IQTree updatedRightChild = rightChild.applyDescendingSubstitution(descendingSubstitution, Optional.empty());
        if (updatedRightChild.isDeclaredAsEmpty()) {
            ImmutableSet<Variable> leftVariables = updatedLeftChild.getVariables();
            ImmutableSet projectedVariables = Sets.union(leftVariables, updatedRightChild.getVariables()).immutableCopy();
            Optional<ConstructionNode> constructionNode = Optional.of(projectedVariables).filter(vars -> !leftVariables.containsAll((Collection)vars)).map(vars -> this.substitutionFactory.getSubstitution(projectedVariables.stream().filter(v -> !leftVariables.contains(v)).collect(ImmutableCollectors.toMap(v -> v, v -> this.termFactory.getNullConstant())))).map(s -> this.iqFactory.createConstructionNode((ImmutableSet<Variable>)projectedVariables, (ImmutableSubstitution<ImmutableTerm>)s));
            return constructionNode.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, updatedLeftChild)).orElse(updatedLeftChild);
        }
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, updatedLeftChild, updatedRightChild);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree leftChild, IQTree rightChild) {
        if (this.containsEqualityRightSpecificVariable(descendingSubstitution, leftChild, rightChild)) {
            return this.transformIntoInnerJoinTree(leftChild, rightChild).applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution);
        }
        IQTree newLeftChild = leftChild.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution);
        IQTree newRightChild = rightChild.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution);
        LeftJoinNode newLJNode = this.getOptionalFilterCondition().map(descendingSubstitution::applyToBooleanExpression).map(this.iqFactory::createLeftJoinNode).orElse(this);
        return this.iqFactory.createBinaryNonCommutativeIQTree(newLJNode, newLeftChild, newRightChild);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, IQTree leftChild, IQTree rightChild, IQTreeCache treeCache) {
        IQTree newLeftChild = leftChild.applyFreshRenaming(renamingSubstitution);
        IQTree newRightChild = rightChild.applyFreshRenaming(renamingSubstitution);
        Optional<ImmutableExpression> newCondition = this.getOptionalFilterCondition().map(renamingSubstitution::applyToBooleanExpression);
        LeftJoinNodeImpl newLeftJoinNode = newCondition.equals(this.getOptionalFilterCondition()) ? this : this.iqFactory.createLeftJoinNode(newCondition);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)newLeftJoinNode, newLeftChild, newRightChild, newTreeCache);
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree leftChild, IQTree rightChild) {
        return Stream.of(leftChild, rightChild).anyMatch(c -> c.isConstructed(variable));
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree leftChild, IQTree rightChild) {
        if (!leftChild.isDistinct()) {
            return false;
        }
        if (rightChild.isDistinct()) {
            return true;
        }
        Optional<ImmutableExpression> optionalFilterCondition = this.getOptionalFilterCondition();
        ImmutableSet<Variable> leftVariables = leftChild.getVariables();
        ImmutableSet<Variable> rightVariables = rightChild.getVariables();
        Sets.SetView commonVariables = Sets.intersection(leftVariables, rightVariables);
        if (!optionalFilterCondition.isPresent() && commonVariables.isEmpty()) {
            return false;
        }
        ImmutableSet<ImmutableSet<Variable>> rightConstraints = rightChild.inferUniqueConstraints();
        if (rightConstraints.isEmpty()) {
            return false;
        }
        ImmutableSet nullableGroups = (ImmutableSet)rightChild.getVariableNullability().getNullableGroups().stream().filter(g -> g.stream().noneMatch(arg_0 -> commonVariables.contains(arg_0))).collect(ImmutableCollectors.toSet());
        VariableNullability variableNullabilityForRight = optionalFilterCondition.map(c -> this.variableNullabilityTools.updateWithFilter((ImmutableExpression)optionalFilterCondition.get(), (ImmutableSet<ImmutableSet<Variable>>)nullableGroups, rightVariables)).orElseGet(() -> this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, rightVariables));
        return rightConstraints.stream().anyMatch(c -> c.stream().noneMatch(variableNullabilityForRight::isPossiblyNullable));
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree leftChild, IQTree rightChild) {
        return this.propagateDownCondition(Optional.of(constraint), leftChild, rightChild);
    }

    @Override
    public void validateNode(IQTree leftChild, IQTree rightChild) throws InvalidIntermediateQueryException {
        this.getOptionalFilterCondition().ifPresent(e -> this.checkExpression((ImmutableExpression)e, (ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild)));
        this.checkNonProjectedVariables((ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild));
    }

    @Override
    public IQTree removeDistincts(IQTree leftChild, IQTree rightChild, IQProperties properties) {
        IQTree newLeftChild = leftChild.removeDistincts();
        IQTree newRightChild = rightChild.removeDistincts();
        IQProperties newProperties = newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? properties.declareDistinctRemovalWithoutEffect() : properties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this, newLeftChild, newRightChild, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree leftChild, IQTree rightChild) {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(IQTree leftChild, IQTree rightChild) {
        return this.computeNotInternallyRequiredVariables((ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild));
    }

    private IQTree propagateDownCondition(Optional<ImmutableExpression> constraint, IQTree leftChild, IQTree rightChild) {
        if (constraint.filter(c -> this.isRejectingRightSpecificNulls((ImmutableExpression)c, leftChild, rightChild)).isPresent()) {
            return this.transformIntoInnerJoinTree(leftChild, rightChild).propagateDownConstraint(constraint.get());
        }
        IQTree newLeftChild = constraint.map(leftChild::propagateDownConstraint).orElse(leftChild);
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, newLeftChild, rightChild);
    }

    private ConditionSimplifier.ExpressionAndSubstitution applyDescendingSubstitutionToExpression(ImmutableExpression initialExpression, ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableSet<Variable> leftChildVariables, ImmutableSet<Variable> rightChildVariables) throws UnsatisfiableConditionException {
        ImmutableExpression expression = descendingSubstitution.applyToBooleanExpression(initialExpression);
        ImmutableExpression.Evaluation results = expression.evaluate2VL(this.coreUtilsFactory.createDummyVariableNullability(expression));
        if (results.isEffectiveFalse()) {
            throw new UnsatisfiableConditionException();
        }
        return results.getExpression().map(e -> this.convertIntoExpressionAndSubstitution((ImmutableExpression)e, leftChildVariables, rightChildVariables)).orElseGet(() -> new ExpressionAndSubstitutionImpl(Optional.empty(), descendingSubstitution.getVariableOrGroundTermFragment()));
    }

    private ConditionSimplifier.ExpressionAndSubstitution convertIntoExpressionAndSubstitution(ImmutableExpression expression, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightVariables) {
        ImmutableSet rightSpecificVariables = (ImmutableSet)rightVariables.stream().filter(v -> !leftVariables.contains(v)).collect(ImmutableCollectors.toSet());
        ImmutableSet expressions = (ImmutableSet)expression.flattenAND().collect(ImmutableCollectors.toSet());
        ImmutableSet downSubstitutionExpressions = (ImmutableSet)expressions.stream().filter(e -> e.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).filter(e -> {
            ImmutableList<? extends ImmutableTerm> arguments = e.getTerms();
            if (!arguments.stream().allMatch(t -> t instanceof NonFunctionalTerm)) return false;
            if (!arguments.stream().anyMatch(arg_0 -> ((ImmutableSet)rightVariables).contains(arg_0))) return false;
            return true;
        }).collect(ImmutableCollectors.toSet());
        ImmutableSubstitution<VariableOrGroundTerm> downSubstitution = this.substitutionFactory.getSubstitution(downSubstitutionExpressions.stream().map(ImmutableFunctionalTerm::getTerms).map(args -> args.get(0) instanceof Variable ? args : args.reverse()).map(args -> args.get(0) instanceof Variable && rightSpecificVariables.contains(args.get(1)) ? args.reverse() : args).collect(ImmutableCollectors.toMap(args -> (Variable)args.get(0), args -> (VariableOrGroundTerm)args.get(1))));
        Optional<ImmutableExpression> newExpression = this.termFactory.getConjunction(expressions.stream().filter(e -> {
            if (!downSubstitutionExpressions.contains(e)) return true;
            if (!e.getTerms().stream().anyMatch(arg_0 -> ((ImmutableSet)rightSpecificVariables).contains(arg_0))) return false;
            return true;
        })).map(downSubstitution::applyToBooleanExpression);
        return new ExpressionAndSubstitutionImpl(newExpression, downSubstitution);
    }

    private boolean isRejectingRightSpecificNulls(ImmutableExpression constraint, IQTree leftChild, IQTree rightChild) {
        Constant nullConstant = this.termFactory.getNullConstant();
        ImmutableSet<Variable> constraintVariables = constraint.getVariables();
        ImmutableMap<Variable, Constant> nullSubstitutionMap = Sets.difference(rightChild.getVariables(), leftChild.getVariables()).stream().filter(arg_0 -> constraintVariables.contains(arg_0)).collect(ImmutableCollectors.toMap(v -> v, v -> nullConstant));
        if (nullSubstitutionMap.isEmpty()) {
            return false;
        }
        ImmutableExpression nullifiedExpression = this.substitutionFactory.getSubstitution(nullSubstitutionMap).applyToBooleanExpression(constraint);
        return nullifiedExpression.evaluate2VL(this.termFactory.createDummyVariableNullability(nullifiedExpression)).isEffectiveFalse();
    }

    private boolean containsEqualityRightSpecificVariable(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree leftChild, IQTree rightChild) {
        ImmutableSet<Variable> leftVariables = leftChild.getVariables();
        ImmutableSet<Variable> rightVariables = rightChild.getVariables();
        ImmutableSet<Variable> domain = descendingSubstitution.getDomain();
        ImmutableCollection range = descendingSubstitution.getImmutableMap().values();
        return rightVariables.stream().filter(v -> !leftVariables.contains(v)).anyMatch(v -> domain.contains(v) && !this.isFreshVariable((ImmutableTerm)descendingSubstitution.get((Variable)v), leftVariables, rightVariables) || range.contains(v));
    }

    private boolean isFreshVariable(ImmutableTerm term, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightVariables) {
        if (term instanceof Variable) {
            Variable variable = (Variable)term;
            return !leftVariables.contains((Object)variable) && !rightVariables.contains((Object)variable);
        }
        return false;
    }

    private IQTree transformIntoInnerJoinTree(IQTree leftChild, IQTree rightChild) {
        return this.iqFactory.createNaryIQTree(this.iqFactory.createInnerJoinNode(this.getOptionalFilterCondition()), (ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild));
    }
}

