/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultiset;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Multiset;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterNodeImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class JoinLikeNodeImpl
extends JoinOrFilterNodeImpl
implements JoinLikeNode {
    protected JoinLikeNodeImpl(Optional<ImmutableExpression> optionalJoinCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, IntermediateQueryFactory iqFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools) {
        super(optionalJoinCondition, nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        ImmutableMultiset childrenVariableBag = (ImmutableMultiset)query.getChildren(this).stream().flatMap(c -> query.getVariables((QueryNode)c).stream()).collect(ImmutableCollectors.toMultiset());
        Stream<Variable> cooccuringVariableStream = childrenVariableBag.entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement);
        return (ImmutableSet)Stream.concat(cooccuringVariableStream, this.getLocallyRequiredVariables().stream()).collect(ImmutableCollectors.toSet());
    }

    protected void checkNonProjectedVariables(ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        HashSet allVariables = new HashSet();
        children.forEach(c -> allVariables.addAll(c.getVariables()));
        for (IQTree child : children) {
            ImmutableSet<Variable> childProjectedVariables = child.getVariables();
            ImmutableSet childNonProjectedVariables = (ImmutableSet)child.getKnownVariables().stream().filter(v -> !childProjectedVariables.contains(v)).collect(ImmutableCollectors.toSet());
            ImmutableSet conflictingVariables = (ImmutableSet)childNonProjectedVariables.stream().filter(allVariables::contains).collect(ImmutableCollectors.toSet());
            if (!conflictingVariables.isEmpty()) {
                throw new InvalidIntermediateQueryException("The following non-projected variables " + conflictingVariables + " are appearing in different children of " + this + ": \n" + children.stream().filter(c -> c.getKnownVariables().stream().anyMatch(arg_0 -> ((ImmutableSet)conflictingVariables).contains(arg_0))).map(c -> "\n" + c.toString()).collect(ImmutableCollectors.toList()));
            }
            allVariables.addAll(childNonProjectedVariables);
        }
    }
}

