/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl.tree;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.IntermediateQueryBuilder;
import it.unibz.inf.ontop.iq.exception.IllegalTreeUpdateException;
import it.unibz.inf.ontop.iq.exception.IntermediateQueryBuilderException;
import it.unibz.inf.ontop.iq.impl.IntermediateQueryImpl;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.impl.tree.DefaultQueryTreeComponent;
import it.unibz.inf.ontop.iq.impl.tree.DefaultTree;
import it.unibz.inf.ontop.iq.impl.tree.QueryTree;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.iq.validation.IntermediateQueryValidator;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import java.util.Optional;

public class DefaultIntermediateQueryBuilder
implements IntermediateQueryBuilder {
    private final ExecutorRegistry executorRegistry;
    private final IntermediateQueryFactory iqFactory;
    private final IntermediateQueryValidator validator;
    private final CoreUtilsFactory coreUtilsFactory;
    private final OntopModelSettings settings;
    private DistinctVariableOnlyDataAtom projectionAtom;
    private QueryTree tree;
    private boolean canEdit;

    @AssistedInject
    protected DefaultIntermediateQueryBuilder(@Assisted ExecutorRegistry executorRegistry, IntermediateQueryFactory iqFactory, IntermediateQueryValidator validator, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings) {
        this.executorRegistry = executorRegistry;
        this.iqFactory = iqFactory;
        this.validator = validator;
        this.coreUtilsFactory = coreUtilsFactory;
        this.settings = settings;
        this.tree = null;
        this.canEdit = true;
    }

    @Override
    public void init(DistinctVariableOnlyDataAtom projectionAtom, QueryNode rootNode) {
        if (this.tree != null) {
            throw new IllegalArgumentException("Already initialized IntermediateQueryBuilder.");
        }
        if (rootNode instanceof ExplicitVariableProjectionNode && !projectionAtom.getVariables().equals(((ExplicitVariableProjectionNode)rootNode).getVariables())) {
            throw new IllegalArgumentException("The root node " + rootNode + " is not consistent with the projection atom " + projectionAtom);
        }
        this.tree = new DefaultTree(rootNode);
        this.projectionAtom = projectionAtom;
        this.canEdit = true;
    }

    @Override
    public void addChild(QueryNode parentNode, QueryNode childNode) throws IntermediateQueryBuilderException {
        this.checkEditMode();
        try {
            this.tree.addChild(parentNode, childNode, Optional.empty(), true, false);
        }
        catch (IllegalTreeUpdateException e) {
            throw new IntermediateQueryBuilderException(e.getMessage());
        }
    }

    @Override
    public void addChild(QueryNode parentNode, QueryNode childNode, BinaryOrderedOperatorNode.ArgumentPosition position) throws IntermediateQueryBuilderException {
        this.checkEditMode();
        try {
            this.tree.addChild(parentNode, childNode, Optional.of(position), true, false);
        }
        catch (IllegalTreeUpdateException e) {
            throw new IntermediateQueryBuilderException(e.getMessage());
        }
    }

    @Override
    public void addChild(QueryNode parentNode, QueryNode child, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) throws IntermediateQueryBuilderException {
        if (optionalPosition.isPresent()) {
            this.addChild(parentNode, child, optionalPosition.get());
        } else {
            this.addChild(parentNode, child);
        }
    }

    @Override
    public void appendSubtree(QueryNode subQueryRoot, IntermediateQuery sourceQuery) {
        if (!sourceQuery.contains(subQueryRoot)) {
            throw new NodeNotInQueryException("Node " + subQueryRoot + " is not in the query");
        }
        ImmutableList<QueryNode> children = sourceQuery.getChildren(subQueryRoot);
        this.addChildren(subQueryRoot, children);
        children.forEach(n -> this.appendSubtree((QueryNode)n, sourceQuery));
    }

    @Override
    public void addChildren(QueryNode parent, ImmutableList<QueryNode> children) {
        if (parent instanceof BinaryOrderedOperatorNode) {
            if (children.size() != 2) {
                throw new IntermediateQueryBuilderException("2 children expected");
            }
            this.addChild(parent, (QueryNode)children.get(0), Optional.of(BinaryOrderedOperatorNode.ArgumentPosition.LEFT));
            this.addChild(parent, (QueryNode)children.get(1), Optional.of(BinaryOrderedOperatorNode.ArgumentPosition.RIGHT));
        } else {
            children.forEach(n -> this.addChild(parent, (QueryNode)n));
        }
    }

    @Override
    public IntermediateQuery build() throws IntermediateQueryBuilderException {
        this.checkInitialization();
        IntermediateQuery query = this.buildQuery(this.projectionAtom, new DefaultQueryTreeComponent(this.tree, this.coreUtilsFactory));
        this.canEdit = false;
        return query;
    }

    protected IntermediateQuery buildQuery(DistinctVariableOnlyDataAtom projectionAtom, QueryTreeComponent treeComponent) {
        return new IntermediateQueryImpl(projectionAtom, treeComponent, this.executorRegistry, this.validator, this.settings, this.iqFactory);
    }

    private void checkInitialization() throws IntermediateQueryBuilderException {
        if (this.tree == null) {
            throw new IntermediateQueryBuilderException("Not initialized!");
        }
    }

    private void checkEditMode() throws IntermediateQueryBuilderException {
        this.checkInitialization();
        if (!this.canEdit) {
            throw new IllegalArgumentException("Cannot be edited anymore (the query has already been built).");
        }
    }

    @Override
    public QueryNode getRootNode() throws IntermediateQueryBuilderException {
        this.checkInitialization();
        return this.tree.getRootNode();
    }

    @Override
    public ImmutableList<QueryNode> getChildren(QueryNode node) throws IntermediateQueryBuilderException {
        this.checkInitialization();
        return this.tree.getChildren(node);
    }

    @Override
    public boolean contains(QueryNode node) {
        return this.tree.contains(node);
    }

    @Override
    public IntermediateQueryFactory getFactory() {
        return this.iqFactory;
    }

    protected ExecutorRegistry getExecutorRegistry() {
        return this.executorRegistry;
    }

    protected IntermediateQueryValidator getValidator() {
        return this.validator;
    }

    protected OntopModelSettings getSettings() {
        return this.settings;
    }

    private class NodeNotInQueryException
    extends OntopInternalBugException {
        private NodeNotInQueryException(String message) {
            super(message);
        }
    }
}

