/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl.tree;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.exception.IllegalTreeUpdateException;
import it.unibz.inf.ontop.iq.impl.tree.ChildrenRelation;
import it.unibz.inf.ontop.iq.impl.tree.StandardChildrenRelation;
import it.unibz.inf.ontop.iq.impl.tree.TreeNode;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class BinaryChildrenRelation
implements ChildrenRelation {
    private final TreeNode parent;
    private Optional<TreeNode> optionalLeftChild;
    private Optional<TreeNode> optionalRightChild;

    protected BinaryChildrenRelation(TreeNode parent) {
        if (!(parent.getQueryNode() instanceof BinaryOrderedOperatorNode)) {
            throw new IllegalArgumentException("The StandardChildrenRelation requires BinaryAsymmetricOperatorNode as parents");
        }
        this.parent = parent;
        this.optionalLeftChild = Optional.empty();
        this.optionalRightChild = Optional.empty();
    }

    private BinaryChildrenRelation(TreeNode parent, Optional<TreeNode> optionalLeftChild, Optional<TreeNode> optionalRightChild) {
        this.parent = parent;
        this.optionalLeftChild = optionalLeftChild;
        this.optionalRightChild = optionalRightChild;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public ImmutableList<TreeNode> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.optionalLeftChild.isPresent()) {
            builder.add((Object)this.optionalLeftChild.get());
        }
        if (this.optionalRightChild.isPresent()) {
            builder.add((Object)this.optionalRightChild.get());
        }
        return builder.build();
    }

    @Override
    public Stream<TreeNode> getChildrenStream() {
        return Stream.of(this.optionalLeftChild, this.optionalRightChild).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public boolean contains(TreeNode node) {
        return this.getChildren().contains((Object)node);
    }

    @Override
    public void addChild(TreeNode childNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition, boolean canReplace) throws IllegalTreeUpdateException {
        if (!optionalPosition.isPresent()) {
            throw new IllegalArgumentException("The BinaryChildrenRelation requires argument positions");
        }
        switch (optionalPosition.get()) {
            case LEFT: {
                if (this.optionalLeftChild.isPresent() && !canReplace && this.optionalLeftChild.get() != childNode) {
                    throw new IllegalTreeUpdateException("Left child node is already present");
                }
                this.optionalLeftChild = Optional.of(childNode);
                break;
            }
            case RIGHT: {
                if (this.optionalRightChild.isPresent() && !canReplace && this.optionalRightChild.get() != childNode) {
                    throw new IllegalTreeUpdateException("Right child node is already present");
                }
                this.optionalRightChild = Optional.of(childNode);
            }
        }
    }

    @Override
    public void replaceChild(TreeNode formerChild, TreeNode newChild) {
        if (this.optionalLeftChild.isPresent() && this.optionalLeftChild.get() == formerChild) {
            this.optionalLeftChild = Optional.of(newChild);
        } else if (this.optionalRightChild.isPresent() && this.optionalRightChild.get() == formerChild) {
            this.optionalRightChild = Optional.of(newChild);
        } else {
            throw new IllegalArgumentException("Unknown former child " + formerChild);
        }
    }

    @Override
    public void removeChild(TreeNode childNode) {
        if (this.optionalLeftChild.isPresent() && this.optionalLeftChild.get() == childNode) {
            this.optionalLeftChild = Optional.empty();
        }
        if (this.optionalRightChild.isPresent() && this.optionalRightChild.get() == childNode) {
            this.optionalRightChild = Optional.empty();
        }
    }

    @Override
    public ImmutableList<QueryNode> getChildQueryNodes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TreeNode treeNode : this.getChildren()) {
            builder.add((Object)treeNode.getQueryNode());
        }
        return builder.build();
    }

    @Override
    public Stream<QueryNode> getChildQueryNodeStream() {
        return this.getChildrenStream().map(TreeNode::getQueryNode);
    }

    @Override
    public Optional<BinaryOrderedOperatorNode.ArgumentPosition> getOptionalPosition(TreeNode childNode) {
        if (this.optionalLeftChild.isPresent() && this.optionalLeftChild.get() == childNode) {
            return Optional.of(BinaryOrderedOperatorNode.ArgumentPosition.LEFT);
        }
        if (this.optionalRightChild.isPresent() && this.optionalRightChild.get() == childNode) {
            return Optional.of(BinaryOrderedOperatorNode.ArgumentPosition.RIGHT);
        }
        throw new IllegalArgumentException(childNode.getQueryNode() + " does not appear as a child.");
    }

    @Override
    public Optional<TreeNode> getChild(BinaryOrderedOperatorNode.ArgumentPosition position) {
        switch (position) {
            case LEFT: {
                return this.optionalLeftChild;
            }
            case RIGHT: {
                return this.optionalRightChild;
            }
        }
        throw new IllegalStateException("Unknown position: " + (Object)((Object)position));
    }

    @Override
    public ChildrenRelation clone(Map<QueryNode, TreeNode> newNodeIndex) {
        return new BinaryChildrenRelation(this.parent.findNewTreeNode(newNodeIndex), this.optionalLeftChild.map(n -> n.findNewTreeNode(newNodeIndex)), this.optionalRightChild.map(n -> n.findNewTreeNode(newNodeIndex)));
    }

    @Override
    public ChildrenRelation convertToBinaryChildrenRelation() {
        return this;
    }

    @Override
    public ChildrenRelation convertToStandardChildrenRelation() {
        StandardChildrenRelation newRelation = new StandardChildrenRelation(this.parent);
        this.getChildrenStream().forEach(c -> newRelation.addChild((TreeNode)c, Optional.empty(), false));
        return newRelation;
    }
}

