/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import javax.annotation.Nullable;

public class IQImpl
implements IQ {
    private final DistinctVariableOnlyDataAtom projectionAtom;
    private final IQTree tree;
    private final IntermediateQueryFactory iqFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    @Nullable
    private VariableGenerator variableGenerator;

    @AssistedInject
    private IQImpl(@Assisted DistinctVariableOnlyDataAtom projectionAtom, @Assisted IQTree tree, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings) {
        this.projectionAtom = projectionAtom;
        this.tree = tree;
        this.iqFactory = iqFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.variableGenerator = null;
        if (settings.isTestModeEnabled()) {
            this.validate();
        }
    }

    @Override
    public DistinctVariableOnlyDataAtom getProjectionAtom() {
        return this.projectionAtom;
    }

    @Override
    public IQTree getTree() {
        return this.tree;
    }

    @Override
    public synchronized VariableGenerator getVariableGenerator() {
        if (this.variableGenerator == null) {
            this.variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)this.tree.getKnownVariables());
        }
        return this.variableGenerator;
    }

    @Override
    public IQ normalizeForOptimization() {
        IQTree newTree = this.tree.normalizeForOptimization(this.getVariableGenerator());
        return newTree == this.tree ? this : this.iqFactory.createIQ(this.projectionAtom, newTree);
    }

    @Override
    public void validate() throws InvalidIntermediateQueryException {
        this.validateProjectedVariables();
        this.tree.validate();
    }

    private void validateProjectedVariables() throws InvalidIntermediateQueryException {
        ImmutableSet<Variable> projectedVariables = this.tree.getVariables();
        if (!projectedVariables.equals(this.projectionAtom.getVariables())) {
            throw new InvalidIntermediateQueryException("The variables projected by the root node" + projectedVariables + " do not match the projection atom " + this.projectionAtom.getVariables());
        }
    }

    public String toString() {
        return this.projectionAtom + "\n" + this.tree.toString();
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        return otherObject instanceof IQ && this.projectionAtom.equals(((IQ)otherObject).getProjectionAtom()) && this.tree.isEquivalentTo(((IQ)otherObject).getTree());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

