/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class LegacyVariableGenerator
implements VariableGenerator {
    private int count;
    private final Set<Variable> knownVariables;
    private static String SUFFIX_PREFIX = "f";
    private final TermFactory termFactory;

    @AssistedInject
    private LegacyVariableGenerator(@Assisted Collection<Variable> knownVariables, TermFactory termFactory) {
        this.termFactory = termFactory;
        this.count = 0;
        this.knownVariables = new HashSet<Variable>(knownVariables);
    }

    @Override
    public void registerAdditionalVariables(Collection<Variable> additionalVariables) {
        this.knownVariables.addAll(additionalVariables);
    }

    @Override
    public Variable generateNewVariableFromVar(Variable previousVariable) {
        Variable newVariable;
        this.knownVariables.add(previousVariable);
        while (this.knownVariables.contains(newVariable = this.termFactory.getVariable(previousVariable.getName() + SUFFIX_PREFIX + this.count++))) {
        }
        this.knownVariables.add(newVariable);
        return newVariable;
    }

    @Override
    public Variable generateNewVariableIfConflicting(Variable previousVariable) {
        Variable newVariable = previousVariable;
        while (this.knownVariables.contains(newVariable)) {
            newVariable = this.termFactory.getVariable(previousVariable.getName() + SUFFIX_PREFIX + this.count++);
        }
        this.knownVariables.add(newVariable);
        return newVariable;
    }

    @Override
    public Variable generateNewVariable() {
        Variable newVariable;
        while (this.knownVariables.contains(newVariable = this.termFactory.getVariable(SUFFIX_PREFIX + this.count++))) {
        }
        this.knownVariables.add(newVariable);
        return newVariable;
    }

    @Override
    public Variable generateNewVariable(String suggestedString) {
        return this.generateNewVariableIfConflicting(this.termFactory.getVariable(suggestedString));
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        return ImmutableSet.copyOf(this.knownVariables);
    }

    @Override
    public VariableGenerator createSnapshot() {
        return new LegacyVariableGenerator((Collection<Variable>)this.getKnownVariables(), this.termFactory);
    }
}

