/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionImpl;
import it.unibz.inf.ontop.substitution.impl.InjectiveVar2VarSubstitutionImpl;
import it.unibz.inf.ontop.substitution.impl.Var2VarSubstitutionImpl;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;

public class SubstitutionFactoryImpl
implements SubstitutionFactory {
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    @Inject
    private SubstitutionFactoryImpl(AtomFactory atomFactory, TermFactory termFactory, CoreUtilsFactory coreUtilsFactory) {
        this.atomFactory = atomFactory;
        this.termFactory = termFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> getSubstitution(ImmutableMap<Variable, T> newSubstitutionMap) {
        return new ImmutableSubstitutionImpl<T>(newSubstitutionMap, this.atomFactory, this.termFactory, this);
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> getSubstitution(Variable k1, T v1) {
        return this.getSubstitution(ImmutableMap.of((Object)k1, v1));
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> getSubstitution(Variable k1, T v1, Variable k2, T v2) {
        return this.getSubstitution(ImmutableMap.of((Object)k1, v1, (Object)k2, v2));
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> getSubstitution(Variable k1, T v1, Variable k2, T v2, Variable k3, T v3) {
        return this.getSubstitution(ImmutableMap.of((Object)k1, v1, (Object)k2, v2, (Object)k3, v3));
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> getSubstitution(Variable k1, T v1, Variable k2, T v2, Variable k3, T v3, Variable k4, T v4) {
        return this.getSubstitution(ImmutableMap.of((Object)k1, v1, (Object)k2, v2, (Object)k3, v3, (Object)k4, v4));
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> getSubstitution() {
        return new ImmutableSubstitutionImpl(ImmutableMap.of(), this.atomFactory, this.termFactory, this);
    }

    @Override
    public Var2VarSubstitution getVar2VarSubstitution(ImmutableMap<Variable, Variable> substitutionMap) {
        return new Var2VarSubstitutionImpl((Map<Variable, ? extends Variable>)substitutionMap, this.atomFactory, this.termFactory, this);
    }

    @Override
    public InjectiveVar2VarSubstitution getInjectiveVar2VarSubstitution(Map<Variable, Variable> substitutionMap) {
        return new InjectiveVar2VarSubstitutionImpl(substitutionMap, this.atomFactory, this.termFactory, (SubstitutionFactory)this);
    }

    @Override
    public InjectiveVar2VarSubstitution generateNotConflictingRenaming(VariableGenerator variableGenerator, ImmutableSet<Variable> variables) {
        ImmutableMap newMap = variables.stream().map(v -> new AbstractMap.SimpleEntry<Variable, Variable>((Variable)v, this.generateNonConflictingVariable((Variable)v, variableGenerator, variables))).filter(pair -> !((Variable)pair.getKey()).equals(pair.getValue())).collect(ImmutableCollectors.toMap());
        return this.getInjectiveVar2VarSubstitution((Map<Variable, Variable>)newMap);
    }

    private Variable generateNonConflictingVariable(Variable v, VariableGenerator variableGenerator, ImmutableSet<Variable> variables) {
        Variable proposedVariable = variableGenerator.generateNewVariableIfConflicting(v);
        if (proposedVariable.equals(v) || !variables.contains((Object)proposedVariable)) {
            return proposedVariable;
        }
        ImmutableSet knownVariables = Sets.union(variableGenerator.getKnownVariables(), variables).immutableCopy();
        VariableGenerator newVariableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)knownVariables);
        Variable newVariable = newVariableGenerator.generateNewVariableFromVar(v);
        variableGenerator.registerAdditionalVariables((Collection<Variable>)ImmutableSet.of((Object)newVariable));
        return newVariable;
    }
}

