/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.impl.GroundTermTools;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class ImmutableSubstitutionTools {
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private ImmutableSubstitutionTools(SubstitutionFactory substitutionFactory) {
        this.substitutionFactory = substitutionFactory;
    }

    public Optional<ImmutableSubstitution<ImmutableTerm>> computeUnidirectionalSubstitution(ImmutableTerm sourceTerm, ImmutableTerm targetTerm) {
        if (sourceTerm instanceof Variable) {
            Variable sourceVariable = (Variable)sourceTerm;
            if (!sourceVariable.equals(targetTerm) && targetTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)targetTerm).getVariables().contains((Object)sourceVariable)) {
                return Optional.empty();
            }
            ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)sourceVariable, (Object)targetTerm));
            return Optional.of(substitution);
        }
        if (sourceTerm instanceof ImmutableFunctionalTerm) {
            if (targetTerm instanceof ImmutableFunctionalTerm) {
                return this.computeUnidirectionalSubstitutionOfFunctionalTerms((ImmutableFunctionalTerm)sourceTerm, (ImmutableFunctionalTerm)targetTerm);
            }
            return Optional.empty();
        }
        if (sourceTerm.equals(targetTerm)) {
            return Optional.of(this.substitutionFactory.getSubstitution());
        }
        return Optional.empty();
    }

    private Optional<ImmutableSubstitution<ImmutableTerm>> computeUnidirectionalSubstitutionOfFunctionalTerms(ImmutableFunctionalTerm sourceFunctionalTerm, ImmutableFunctionalTerm targetFunctionalTerm) {
        if (!sourceFunctionalTerm.getFunctionSymbol().equals(targetFunctionalTerm.getFunctionSymbol())) {
            return Optional.empty();
        }
        if (sourceFunctionalTerm.isGround()) {
            if (sourceFunctionalTerm.equals(targetFunctionalTerm)) {
                return Optional.of(this.substitutionFactory.getSubstitution());
            }
            return Optional.empty();
        }
        ImmutableList<? extends ImmutableTerm> sourceChildren = sourceFunctionalTerm.getTerms();
        ImmutableList<? extends ImmutableTerm> targetChildren = targetFunctionalTerm.getTerms();
        int sourceArity = sourceChildren.size();
        if (sourceArity != targetChildren.size()) {
            return Optional.empty();
        }
        ImmutableSubstitution<ImmutableTerm> unifier = this.substitutionFactory.getSubstitution();
        for (int i = 0; i < sourceArity; ++i) {
            Optional<ImmutableSubstitution<ImmutableTerm>> optionalChildUnifier = this.computeUnidirectionalSubstitution((ImmutableTerm)sourceChildren.get(i), (ImmutableTerm)targetChildren.get(i));
            if (!optionalChildUnifier.isPresent()) {
                return Optional.empty();
            }
            ImmutableSubstitution<ImmutableTerm> childUnifier = optionalChildUnifier.get();
            Optional<ImmutableSubstitution<ImmutableTerm>> optionalMergedUnifier = unifier.union(childUnifier);
            if (!optionalMergedUnifier.isPresent()) {
                return Optional.empty();
            }
            unifier = optionalMergedUnifier.get();
        }
        return Optional.of(unifier);
    }

    ImmutableSubstitution<VariableOrGroundTerm> convertIntoVariableOrGroundTermSubstitution(ImmutableSubstitution<ImmutableTerm> substitution) {
        ImmutableMap<Variable, VariableOrGroundTerm> map = substitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> GroundTermTools.convertIntoVariableOrGroundTerm((ImmutableTerm)e.getValue())));
        return this.substitutionFactory.getSubstitution(map);
    }

    public <T extends ImmutableTerm> ImmutableSubstitution<T> prioritizeRenaming(ImmutableSubstitution<T> substitution, ImmutableSet<Variable> priorityVariables) {
        ImmutableMultimap<Variable, Variable> renamingMultimap = substitution.getImmutableMap().entrySet().stream().filter(e -> priorityVariables.contains(e.getKey()) && e.getValue() instanceof Variable && !priorityVariables.contains(e.getValue())).collect(ImmutableCollectors.toMultimap(e -> (Variable)e.getValue(), Map.Entry::getKey));
        if (renamingMultimap.isEmpty()) {
            return substitution;
        }
        ImmutableMap<Variable, Variable> renamingMap = renamingMultimap.asMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (Variable)((Collection)e.getValue()).iterator().next()));
        InjectiveVar2VarSubstitution renamingSubstitution = this.substitutionFactory.getInjectiveVar2VarSubstitution((Map<Variable, Variable>)renamingMap);
        return renamingSubstitution.composeWith(substitution);
    }
}

