/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.FunctionalTermSimplification;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RDFTermFunctionSymbolImpl
extends FunctionSymbolImpl
implements RDFTermFunctionSymbol {
    protected RDFTermFunctionSymbolImpl(TermType lexicalType, MetaRDFTermType typeTermType) {
        super("RDF", (ImmutableList<TermType>)ImmutableList.of((Object)lexicalType, (Object)typeTermType));
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return true;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.size() != 2) {
            throw new IllegalArgumentException("Wrong arity");
        }
        return Optional.of(terms.get(1)).filter(t -> t instanceof RDFTermTypeConstant).map(t -> (RDFTermTypeConstant)t).map(RDFTermTypeConstant::getRDFTermType).map(TermTypeInference::declareTermType);
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().allMatch(ImmutableTerm::isNull)) {
            return termFactory.getNullConstant();
        }
        if (newTerms.stream().allMatch(t -> t instanceof NonNullConstant)) {
            DBConstant lexicalConstant = Optional.of(newTerms.get(0)).filter(c -> c instanceof DBConstant).map(c -> (DBConstant)c).orElseThrow(() -> new MinorOntopInternalBugException("The constant for the lexical part was expected to be a DBConstant"));
            RDFTermType rdfTermType = Optional.of(newTerms.get(1)).filter(c -> c instanceof RDFTermTypeConstant).map(c -> (RDFTermTypeConstant)c).map(RDFTermTypeConstant::getRDFTermType).orElseThrow(() -> new MinorOntopInternalBugException("The second constant argument was expected to be a RDFTermTypeConstant"));
            return rdfTermType.isAbstract() ? termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms) : termFactory.getRDFConstant(lexicalConstant.getValue(), rdfTermType);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableList<? extends ImmutableTerm> terms, ImmutableTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        if (otherTerm instanceof RDFConstant) {
            RDFConstant otherConstant = (RDFConstant)otherTerm;
            ImmutableExpression conjunction = termFactory.getConjunction(termFactory.getStrictEquality((ImmutableTerm)terms.get(0), termFactory.getDBStringConstant(otherConstant.getValue()), new ImmutableTerm[0]), termFactory.getStrictEquality((ImmutableTerm)terms.get(1), termFactory.getRDFTermTypeConstant(otherConstant.getType()), new ImmutableTerm[0]));
            return conjunction.evaluate(variableNullability, true);
        }
        if (otherTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)otherTerm).getFunctionSymbol().equals(this)) {
            ImmutableList<? extends ImmutableTerm> otherSubTerms = ((ImmutableFunctionalTerm)otherTerm).getTerms();
            return termFactory.getConjunction(termFactory.getStrictEquality((ImmutableTerm)terms.get(0), (ImmutableTerm)otherSubTerms.get(0), new ImmutableTerm[0]), termFactory.getStrictEquality((ImmutableTerm)terms.get(1), (ImmutableTerm)otherSubTerms.get(1), new ImmutableTerm[0])).evaluate(variableNullability, true);
        }
        return super.evaluateStrictEq(terms, otherTerm, termFactory, variableNullability);
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableSet<Variable> nullableVariables = variableNullability.getNullableVariables();
        Optional<ImmutableExpression> optionalExpression = termFactory.getConjunction(terms.stream().filter(t -> t.isNullable(nullableVariables)).map(termFactory::getDBIsNotNull));
        return optionalExpression.map(e -> e.evaluate(variableNullability, true)).orElseGet(IncrementalEvaluation::declareIsTrue);
    }

    @Override
    public Stream<Variable> proposeProvenanceVariables(ImmutableList<? extends ImmutableTerm> terms) {
        ImmutableTerm lexicalTerm = (ImmutableTerm)terms.get(0);
        if (lexicalTerm instanceof Variable) {
            return Stream.of((Variable)lexicalTerm);
        }
        return Optional.of(lexicalTerm).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).map(ImmutableFunctionalTerm::proposeProvenanceVariables).orElseGet(Stream::empty);
    }

    @Override
    protected boolean canBeSafelyDecomposedIntoConjunction(ImmutableList<? extends ImmutableTerm> terms, VariableNullability variableNullability, ImmutableList<? extends ImmutableTerm> otherTerms) {
        return true;
    }

    @Override
    public FunctionalTermSimplification simplifyAsGuaranteedToBeNonNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        ImmutableMap<Integer, FunctionalTermSimplification> subTermSimplifications = IntStream.range(0, terms.size()).boxed().filter(i -> terms.get(i.intValue()) instanceof ImmutableFunctionalTerm).collect(ImmutableCollectors.toMap(i -> i, i -> ((ImmutableFunctionalTerm)terms.get(i.intValue())).simplifyAsGuaranteedToBeNonNull()));
        ImmutableList newSubTerms = (ImmutableList)IntStream.range(0, terms.size()).boxed().map(i -> Optional.ofNullable(subTermSimplifications.get(i)).map(FunctionalTermSimplification::getSimplifiedTerm).orElseGet(() -> (ImmutableTerm)terms.get(i.intValue()))).collect(ImmutableCollectors.toList());
        ImmutableFunctionalTerm simplifiedTerm = termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newSubTerms);
        ImmutableSet simplifiableVariables = (ImmutableSet)Stream.concat(subTermSimplifications.values().stream().flatMap(s -> s.getSimplifiableVariables().stream()), terms.stream().filter(t -> t instanceof Variable).map(v -> (Variable)v)).collect(ImmutableCollectors.toSet());
        return FunctionalTermSimplification.create(simplifiedTerm, (ImmutableSet<Variable>)simplifiableVariables);
    }
}

