/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class RDFDatatypeStringFunctionSymbolImpl
extends FunctionSymbolImpl {
    private final DBTermType dbStringType;

    protected RDFDatatypeStringFunctionSymbolImpl(MetaRDFTermType metaRDFType, DBTermType dbStringType) {
        super("RDF_DATATYPE_STR", (ImmutableList<TermType>)ImmutableList.of((Object)metaRDFType));
        this.dbStringType = dbStringType;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.dbStringType));
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (newTerm instanceof RDFTermTypeConstant) {
            RDFTermType termType = ((RDFTermTypeConstant)newTerm).getRDFTermType();
            return Optional.of(termType).filter(t -> t instanceof RDFDatatype).map(t -> ((RDFDatatype)t).getIRI()).map(IRI::getIRIString).map(s -> termFactory.getDBStringConstant((String)s)).orElseGet(termFactory::getNullConstant);
        }
        return this.tryToLiftMagicNumbers(newTerms, termFactory, variableNullability, false).orElseGet(() -> super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }
}

