/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;

public class LexicalLangMatchesFunctionSymbolImpl
extends BooleanFunctionSymbolImpl {
    protected LexicalLangMatchesFunctionSymbolImpl(DBTermType dbStringType, DBTermType dbBooleanTermType) {
        super("LEX_LANG_MATCHES", (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType, (Object)dbStringType), dbBooleanTermType);
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().anyMatch(t -> t instanceof Constant && t.isNull())) {
            return termFactory.getNullConstant();
        }
        if (newTerms.stream().allMatch(t -> t instanceof NonNullConstant)) {
            ImmutableList<ImmutableTerm> constants = newTerms;
            return termFactory.getDBBooleanConstant(this.isMatching(((NonNullConstant)constants.get(0)).getValue(), ((NonNullConstant)constants.get(1)).getValue()));
        }
        return super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    private boolean isMatching(String langTag, String langRange) {
        if (langRange.equals("*")) {
            return !langTag.isEmpty();
        }
        return langTag.toLowerCase().startsWith(langRange.toLowerCase());
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }
}

