/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.FunctionalTermSimplification;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonConstantTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.FunctionalTermNullabilityImpl;
import it.unibz.inf.ontop.model.term.impl.PredicateImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import it.unibz.inf.ontop.utils.impl.VariableGeneratorImpl;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class FunctionSymbolImpl
extends PredicateImpl
implements FunctionSymbol {
    private final ImmutableList<TermType> expectedBaseTypes;

    protected FunctionSymbolImpl(@Nonnull String name, @Nonnull ImmutableList<TermType> expectedBaseTypes) {
        super(name, expectedBaseTypes.size());
        this.expectedBaseTypes = expectedBaseTypes;
    }

    protected abstract boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms();

    @Override
    public FunctionSymbol.FunctionalTermNullability evaluateNullability(ImmutableList<? extends NonFunctionalTerm> arguments, VariableNullability childNullability, TermFactory termFactory) {
        IncrementalEvaluation evaluation = this.evaluateIsNotNull(this.transformIntoRegularArguments(arguments, termFactory), termFactory, childNullability);
        switch (evaluation.getStatus()) {
            case SIMPLIFIED_EXPRESSION: {
                return evaluation.getNewExpression().filter(e -> e.getFunctionSymbol().equals(termFactory.getDBFunctionSymbolFactory().getDBIsNotNull())).map(e -> e.getTerm(0)).filter(t -> t instanceof Variable).map(t -> (Variable)t).map(FunctionalTermNullabilityImpl::new).orElseGet(() -> new FunctionalTermNullabilityImpl(true));
            }
            case IS_NULL: {
                throw new MinorOntopInternalBugException("An IS_NOT_NULL cannot evaluate to NULL");
            }
            case IS_TRUE: {
                return new FunctionalTermNullabilityImpl(false);
            }
        }
        return new FunctionalTermNullabilityImpl(true);
    }

    protected ImmutableList<? extends ImmutableTerm> transformIntoRegularArguments(ImmutableList<? extends NonFunctionalTerm> arguments, TermFactory termFactory) {
        return arguments;
    }

    @Override
    public ImmutableTerm simplify(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList newTerms = (ImmutableList)terms.stream().map(t -> t instanceof ImmutableFunctionalTerm ? t.simplify(variableNullability) : t).collect(ImmutableCollectors.toList());
        if (!this.tolerateNulls() && newTerms.stream().anyMatch(t -> t instanceof Constant && t.isNull())) {
            return termFactory.getNullConstant();
        }
        return this.simplifyIfElseNull((ImmutableList<ImmutableTerm>)newTerms, termFactory, variableNullability).orElseGet(() -> this.buildTermAfterEvaluation((ImmutableList<ImmutableTerm>)newTerms, termFactory, variableNullability));
    }

    private Optional<ImmutableTerm> simplifyIfElseNull(ImmutableList<ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (!this.enableIfElseNullLifting() || this.tolerateNulls() || this instanceof DBIfElseNullFunctionSymbol) {
            return Optional.empty();
        }
        return IntStream.range(0, terms.size()).filter(i -> {
            ImmutableTerm term = (ImmutableTerm)terms.get(i);
            return term instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term).getFunctionSymbol() instanceof DBIfElseNullFunctionSymbol;
        }).boxed().findAny().map(i -> this.liftIfElseNull(terms, (int)i, termFactory, variableNullability));
    }

    private ImmutableTerm liftIfElseNull(ImmutableList<ImmutableTerm> terms, int index, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableFunctionalTerm ifElseNullTerm = (ImmutableFunctionalTerm)terms.get(index);
        ImmutableExpression condition = (ImmutableExpression)ifElseNullTerm.getTerm(0);
        ImmutableTerm conditionalTerm = ifElseNullTerm.getTerm(1);
        ImmutableList newTerms = (ImmutableList)IntStream.range(0, terms.size()).boxed().map(i -> i == index ? conditionalTerm : (ImmutableTerm)terms.get(i.intValue())).collect(ImmutableCollectors.toList());
        ImmutableFunctionalTerm newFunctionalTerm = this instanceof BooleanFunctionSymbol ? termFactory.getBooleanIfElseNull(condition, termFactory.getImmutableExpression((BooleanFunctionSymbol)((Object)this), (ImmutableList<? extends ImmutableTerm>)newTerms)) : termFactory.getIfElseNull(condition, termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newTerms));
        return newFunctionalTerm.simplify(variableNullability);
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableList<? extends ImmutableTerm> terms, ImmutableTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        boolean incompatibleTypesDetected = this.inferType(terms).flatMap(TermTypeInference::getTermType).map(t1 -> otherTerm.inferType().flatMap(TermTypeInference::getTermType).map(t2 -> this.areIncompatibleForStrictEq((TermType)t1, (TermType)t2)).orElse(false)).orElse(false);
        if (incompatibleTypesDetected) {
            return IncrementalEvaluation.declareIsFalse();
        }
        if (otherTerm instanceof ImmutableFunctionalTerm) {
            return this.evaluateStrictEqWithFunctionalTerm(terms, (ImmutableFunctionalTerm)otherTerm, termFactory, variableNullability);
        }
        if (otherTerm instanceof Constant && otherTerm.isNull()) {
            return IncrementalEvaluation.declareIsNull();
        }
        if (otherTerm instanceof NonNullConstant) {
            return this.evaluateStrictEqWithNonNullConstant(terms, (NonNullConstant)otherTerm, termFactory, variableNullability);
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    private boolean areIncompatibleForStrictEq(TermType type1, TermType type2) {
        if (type1.equals(type2)) {
            return false;
        }
        return !(type1 instanceof DBTermType) || !(type2 instanceof DBTermType);
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (!this.mayReturnNullWithoutNullArguments() && !this.tolerateNulls()) {
            ImmutableSet<Variable> nullableVariables = variableNullability.getNullableVariables();
            Optional<ImmutableExpression> optionalExpression = termFactory.getConjunction(terms.stream().filter(t -> t.isNullable(nullableVariables)).map(termFactory::getDBIsNotNull));
            return optionalExpression.map(e -> e.evaluate(variableNullability, true)).orElseGet(IncrementalEvaluation::declareIsTrue);
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    @Override
    public boolean isDeterministic() {
        return !(this instanceof NonDeterministicDBFunctionSymbol);
    }

    @Override
    public boolean isNullable(ImmutableSet<Integer> nullableIndexes) {
        return this.mayReturnNullWithoutNullArguments() || !nullableIndexes.isEmpty();
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    @Override
    public Stream<Variable> proposeProvenanceVariables(ImmutableList<? extends ImmutableTerm> terms) {
        if (!this.mayReturnNullWithoutNullArguments() && !this.tolerateNulls()) {
            return terms.stream().filter(t -> t instanceof NonConstantTerm).flatMap(t -> t instanceof Variable ? Stream.of((Variable)t) : ((ImmutableFunctionalTerm)t).proposeProvenanceVariables());
        }
        return Stream.empty();
    }

    @Override
    public FunctionalTermSimplification simplifyAsGuaranteedToBeNonNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        if (!this.mayReturnNullWithoutNullArguments() && !this.tolerateNulls()) {
            ImmutableMap<Integer, FunctionalTermSimplification> subTermSimplifications = IntStream.range(0, terms.size()).boxed().filter(i -> terms.get(i.intValue()) instanceof ImmutableFunctionalTerm).collect(ImmutableCollectors.toMap(i -> i, i -> ((ImmutableFunctionalTerm)terms.get(i.intValue())).simplifyAsGuaranteedToBeNonNull()));
            ImmutableList newSubTerms = (ImmutableList)IntStream.range(0, terms.size()).boxed().map(i -> Optional.ofNullable(subTermSimplifications.get(i)).map(FunctionalTermSimplification::getSimplifiedTerm).orElseGet(() -> (ImmutableTerm)terms.get(i.intValue()))).collect(ImmutableCollectors.toList());
            ImmutableFunctionalTerm simplifiedTerm = termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newSubTerms);
            ImmutableSet simplifiableVariables = (ImmutableSet)Stream.concat(subTermSimplifications.values().stream().flatMap(s -> s.getSimplifiableVariables().stream()), terms.stream().filter(t -> t instanceof Variable).map(v -> (Variable)v)).collect(ImmutableCollectors.toSet());
            return FunctionalTermSimplification.create(simplifiedTerm, (ImmutableSet<Variable>)simplifiableVariables);
        }
        return FunctionalTermSimplification.create(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, terms), (ImmutableSet<Variable>)ImmutableSet.of());
    }

    protected IncrementalEvaluation evaluateStrictEqWithFunctionalTerm(ImmutableList<? extends ImmutableTerm> terms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        if (otherTerm.getFunctionSymbol().equals(this) && this.isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms()) {
            if (this.getArity() == 0) {
                return IncrementalEvaluation.declareIsTrue();
            }
            if (!this.canBeSafelyDecomposedIntoConjunction(terms, variableNullability, otherTerm.getTerms())) {
                return IncrementalEvaluation.declareSameExpression();
            }
            ImmutableExpression newExpression = termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)IntStream.range(0, this.getArity()).boxed().map(i -> termFactory.getStrictEquality((ImmutableTerm)terms.get(i.intValue()), otherTerm.getTerm((int)i), new ImmutableTerm[0])).collect(ImmutableCollectors.toList())));
            return newExpression.evaluate(variableNullability, true);
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    protected boolean canBeSafelyDecomposedIntoConjunction(ImmutableList<? extends ImmutableTerm> terms, VariableNullability variableNullability, ImmutableList<? extends ImmutableTerm> otherTerms) {
        if (this.mayReturnNullWithoutNullArguments()) {
            return false;
        }
        if (this.getArity() == 1) {
            return true;
        }
        return !variableNullability.canPossiblyBeNullSeparately(terms) && !variableNullability.canPossiblyBeNullSeparately(otherTerms);
    }

    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        return IncrementalEvaluation.declareSameExpression();
    }

    protected abstract boolean tolerateNulls();

    protected abstract boolean mayReturnNullWithoutNullArguments();

    protected boolean enableIfElseNullLifting() {
        return false;
    }

    @Override
    public Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> analyzeInjectivity(ImmutableList<? extends ImmutableTerm> arguments, ImmutableSet<Variable> nonFreeVariables, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        if (!this.isDeterministic()) {
            return Optional.empty();
        }
        if (arguments.stream().allMatch(t -> t instanceof GroundTerm && ((GroundTerm)t).isDeterministic() || nonFreeVariables.contains(t))) {
            return Optional.of(termFactory.getFunctionalTermDecomposition(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, arguments)));
        }
        if (!this.isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms()) {
            return Optional.empty();
        }
        return Optional.of(this.decomposeInjectiveTopFunctionalTerm(arguments, nonFreeVariables, variableNullability, variableGenerator, termFactory));
    }

    protected ImmutableFunctionalTerm.FunctionalTermDecomposition decomposeInjectiveTopFunctionalTerm(ImmutableList<? extends ImmutableTerm> arguments, ImmutableSet<Variable> nonFreeVariables, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableMap<Integer, Optional> subTermDecompositions = IntStream.range(0, this.getArity()).filter(i -> arguments.get(i) instanceof ImmutableFunctionalTerm).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> ((ImmutableFunctionalTerm)arguments.get(i.intValue())).analyzeInjectivity(nonFreeVariables, variableNullability, variableGenerator)));
        ImmutableList newArguments = (ImmutableList)IntStream.range(0, this.getArity()).boxed().map(i -> Optional.ofNullable(subTermDecompositions.get(i)).map(optionalDecomposition -> optionalDecomposition.map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).orElseGet(variableGenerator::generateNewVariable)).orElseGet(() -> (ImmutableTerm)arguments.get(i.intValue()))).collect(ImmutableCollectors.toList());
        ImmutableMap subTermSubstitutionMap = subTermDecompositions.entrySet().stream().flatMap(e -> ((Optional)e.getValue()).map(d -> d.getSubTermSubstitutionMap().map(s -> s.entrySet().stream()).orElseGet(Stream::empty)).orElseGet(() -> Stream.of(Maps.immutableEntry((Object)((Variable)newArguments.get(((Integer)e.getKey()).intValue())), (Object)((ImmutableFunctionalTerm)arguments.get(((Integer)e.getKey()).intValue())))))).collect(ImmutableCollectors.toMap());
        ImmutableFunctionalTerm newFunctionalTerm = termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newArguments);
        return subTermSubstitutionMap.isEmpty() ? termFactory.getFunctionalTermDecomposition(newFunctionalTerm) : termFactory.getFunctionalTermDecomposition(newFunctionalTerm, subTermSubstitutionMap);
    }

    protected final boolean isInjective(ImmutableList<? extends ImmutableTerm> arguments, VariableNullability variableNullability, TermFactory termFactory) {
        VariableGeneratorImpl testVariableGenerator = new VariableGeneratorImpl((Collection)arguments.stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet()), termFactory);
        return this.analyzeInjectivity(arguments, (ImmutableSet<Variable>)ImmutableSet.of(), variableNullability, testVariableGenerator, termFactory).filter(d -> !d.getSubTermSubstitutionMap().isPresent()).isPresent();
    }

    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    protected ImmutableList<TermType> getExpectedBaseTypes() {
        return this.expectedBaseTypes;
    }

    @Override
    public TermType getExpectedBaseType(int index) {
        return (TermType)this.expectedBaseTypes.get(index);
    }

    protected Optional<ImmutableTerm> tryToLiftMagicNumbers(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability, boolean isBoolean) {
        Optional<ImmutableFunctionalTerm> optionalTermTypeFunctionalTerm = newTerms.stream().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol).findFirst();
        if (optionalTermTypeFunctionalTerm.isPresent()) {
            ImmutableFunctionalTerm firstTermTypeFunctionalTerm = optionalTermTypeFunctionalTerm.get();
            int index = newTerms.indexOf((Object)firstTermTypeFunctionalTerm);
            ImmutableTerm newTerm = ((RDFTermTypeFunctionSymbol)firstTermTypeFunctionalTerm.getFunctionSymbol()).lift(firstTermTypeFunctionalTerm.getTerms(), c -> termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)((ImmutableList)IntStream.range(0, newTerms.size()).boxed().map(i -> i == index ? c : (ImmutableTerm)newTerms.get(i.intValue())).collect(ImmutableCollectors.toList()))), termFactory, isBoolean).simplify(variableNullability);
            return Optional.of(newTerm);
        }
        return Optional.empty();
    }
}

