/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.AbstractCommonDenominatorFunctionSymbol;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;

public class CommonDenominatorFunctionSymbolImpl
extends AbstractCommonDenominatorFunctionSymbol {
    CommonDenominatorFunctionSymbolImpl(int arity, MetaRDFTermType metaRDFTermType) {
        super("COMMON_TYPE" + arity, arity, metaRDFTermType);
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        Optional<RDFTermTypeConstant> optionalMergedTypeConstant = newTerms.stream().filter(t -> t instanceof RDFTermTypeConstant).map(c -> (RDFTermTypeConstant)c).reduce((c1, c2) -> termFactory.getRDFTermTypeConstant((RDFTermType)c1.getRDFTermType().getCommonDenominator(c2.getRDFTermType())));
        if (optionalMergedTypeConstant.filter(t -> t.getRDFTermType().isAbstract()).isPresent()) {
            return termFactory.getNullConstant();
        }
        ImmutableList otherTerms = (ImmutableList)newTerms.stream().filter(t -> !(t instanceof RDFTermTypeConstant)).distinct().collect(ImmutableCollectors.toList());
        if (otherTerms.isEmpty()) {
            return optionalMergedTypeConstant.orElseThrow(() -> new MinorOntopInternalBugException("At least one term must remain"));
        }
        if (otherTerms.stream().allMatch(a -> a instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)a).getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol)) {
            return this.simplifyUsingMagicNumbers((ImmutableList<ImmutableFunctionalTerm>)otherTerms, optionalMergedTypeConstant, termFactory);
        }
        return optionalMergedTypeConstant.map(c -> termFactory.getCommonDenominatorFunctionalTerm((ImmutableList<ImmutableTerm>)ImmutableList.builder().add(c).addAll((Iterable)otherTerms).build())).filter(t -> t.getArity() < this.getArity()).map(t -> t.simplify(variableNullability)).orElseGet(() -> super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability));
    }

    @Override
    protected Optional<RDFTermTypeConstant> evaluateCombination(ImmutableList<RDFTermTypeConstant> constants, Optional<RDFTermTypeConstant> optionalMergedTypeConstant, TermFactory termFactory) {
        return optionalMergedTypeConstant.map(c -> Stream.concat(Stream.of(c), constants.stream())).orElseGet(() -> constants.stream()).reduce((c1, c2) -> termFactory.getRDFTermTypeConstant((RDFTermType)c1.getRDFTermType().getCommonDenominator(c2.getRDFTermType()))).filter(c -> !c.getRDFTermType().isAbstract());
    }
}

