/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class AbstractBinaryBooleanOperatorSPARQLFunctionSymbol
extends SPARQLFunctionSymbolImpl {
    private final RDFDatatype xsdBooleanType;

    protected AbstractBinaryBooleanOperatorSPARQLFunctionSymbol(@Nonnull String functionSymbolName, @Nonnull String officialName, RDFDatatype xsdBooleanType) {
        super(functionSymbolName, officialName, (ImmutableList<TermType>)ImmutableList.of((Object)xsdBooleanType, (Object)xsdBooleanType));
        this.xsdBooleanType = xsdBooleanType;
    }

    @Override
    protected final ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().allMatch(t -> this.isRDFFunctionalTerm((ImmutableTerm)t) || t instanceof Constant)) {
            ImmutableList subLexicalTerms = (ImmutableList)newTerms.stream().map(t -> this.extractLexicalTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            ImmutableTerm lexicalTerm = this.computeLexicalTerm((ImmutableList<ImmutableTerm>)subLexicalTerms, termFactory);
            ImmutableFunctionalTerm typeTerm = termFactory.getIfElseNull(termFactory.getDBIsNotNull(lexicalTerm), termFactory.getRDFTermTypeConstant(this.xsdBooleanType));
            return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    private ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, TermFactory termFactory) {
        DBTermType dbBooleanType = termFactory.getTypeFactory().getDBTypeFactory().getDBBooleanType();
        ImmutableList booleanSubTerms = (ImmutableList)subLexicalTerms.stream().map(t -> termFactory.getConversionFromRDFLexical2DB(dbBooleanType, (ImmutableTerm)t, this.xsdBooleanType)).map(t -> (ImmutableExpression)t).collect(ImmutableCollectors.toList());
        return termFactory.getConversion2RDFLexical(dbBooleanType, this.computeExpression((ImmutableList<ImmutableExpression>)booleanSubTerms, termFactory), this.xsdBooleanType);
    }

    protected abstract ImmutableTerm computeExpression(ImmutableList<ImmutableExpression> var1, TermFactory var2);

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.xsdBooleanType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }
}

