/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import java.util.function.Function;

public class DefaultTypedDBMathBinaryOperator
extends FunctionSymbolImpl
implements DBMathBinaryOperator {
    private final String template;
    private final DBTermType dbNumericType;

    protected DefaultTypedDBMathBinaryOperator(String operatorString, DBTermType dbNumericType) {
        super(dbNumericType.toString() + operatorString, (ImmutableList<TermType>)ImmutableList.of((Object)dbNumericType, (Object)dbNumericType));
        this.template = "(%s " + operatorString + " %s)";
        this.dbNumericType = dbNumericType;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format(this.template, termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.dbNumericType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return false;
    }
}

