/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBTypeConversionFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class DefaultNumberNormAsBooleanFunctionSymbol
extends AbstractDBTypeConversionFunctionSymbolImpl {
    private final DBTermType numberType;

    protected DefaultNumberNormAsBooleanFunctionSymbol(DBTermType numberType, DBTermType stringType) {
        super(numberType + "2BooleanLexicalNorm", numberType, stringType);
        this.numberType = numberType;
    }

    @Override
    public Optional<DBTermType> getInputType() {
        return Optional.of(this.numberType);
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm convertDBConstant(DBConstant constant, TermFactory termFactory) throws AbstractDBTypeConversionFunctionSymbolImpl.DBTypeConversionException {
        return this.transformIntoDBCase(constant, termFactory).simplify();
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableFunctionalTerm newFunctionalTerm = this.transformIntoDBCase((ImmutableTerm)terms.get(0), termFactory);
        return termConverter.apply(newFunctionalTerm);
    }

    protected ImmutableFunctionalTerm transformIntoDBCase(ImmutableTerm subTerm, TermFactory termFactory) {
        return termFactory.getDBCase(Stream.of(this.buildEntry(subTerm, true, termFactory), this.buildEntry(subTerm, false, termFactory)), termFactory.getNullConstant(), false);
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        String valueString;
        ImmutableTerm term = (ImmutableTerm)terms.get(0);
        ImmutableExpression zeroEquality = termFactory.getDBNonStrictNumericEquality(term, termFactory.getDBIntegerConstant(0));
        switch (valueString = otherTerm.getValue()) {
            case "false": {
                return zeroEquality.evaluate(variableNullability, true);
            }
            case "true": {
                return termFactory.getDBNot(zeroEquality).evaluate(variableNullability, true);
            }
        }
        return termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getDBIsNull(term))).evaluate(variableNullability, true);
    }

    private Map.Entry<ImmutableExpression, ? extends ImmutableTerm> buildEntry(ImmutableTerm term, boolean b, TermFactory termFactory) {
        DBConstant zero = termFactory.getDBIntegerConstant(0);
        ImmutableExpression zeroEquality = termFactory.getDBNonStrictNumericEquality(term, zero);
        ImmutableExpression condition = b ? termFactory.getDBNot(zeroEquality) : zeroEquality;
        return Maps.immutableEntry((Object)condition, (Object)termFactory.getXsdBooleanLexicalConstant(b));
    }
}

