/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import io.mikael.urlbuilder.util.Decoder;
import io.mikael.urlbuilder.util.Encoder;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import java.nio.charset.Charset;

public abstract class AbstractR2RMLSafeIRIEncodeFunctionSymbol
extends AbstractTypedDBFunctionSymbol {
    private final Encoder iriEncoder;
    private final Decoder iriDecoder;

    protected AbstractR2RMLSafeIRIEncodeFunctionSymbol(DBTermType dbStringType) {
        super("R2RMLIRISafeEncode", (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType), dbStringType);
        Charset charset = Charset.forName("utf-8");
        this.iriEncoder = new Encoder(charset);
        this.iriDecoder = new Decoder(charset);
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        FunctionSymbol functionSymbol;
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (newTerm instanceof DBConstant) {
            return this.encodeConstant((DBConstant)newTerm, termFactory);
        }
        if (newTerm instanceof ImmutableFunctionalTerm && (functionSymbol = ((ImmutableFunctionalTerm)newTerm).getFunctionSymbol()) instanceof DBTypeConversionFunctionSymbol && ((DBTypeConversionFunctionSymbol)functionSymbol).getInputType().filter(t -> !t.isNeedingIRISafeEncoding()).isPresent()) {
            return newTerm;
        }
        return super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    private DBConstant encodeConstant(DBConstant constant, TermFactory termFactory) {
        return termFactory.getDBStringConstant(this.iriEncoder.encodeQueryElement(constant.getValue()));
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        DBConstant decodedConstant = termFactory.getDBStringConstant(this.iriDecoder.urlDecode(otherTerm.getValue(), true));
        ImmutableExpression newExpression = termFactory.getStrictEquality((ImmutableTerm)terms.get(0), decodedConstant, new ImmutableTerm[0]);
        return newExpression.evaluate(variableNullability, true);
    }
}

