/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfThenFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractArgDependentTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class AbstractDBIfThenFunctionSymbol
extends AbstractArgDependentTypedDBFunctionSymbol
implements DBIfThenFunctionSymbol {
    protected final boolean doOrderingMatter;

    protected AbstractDBIfThenFunctionSymbol(@Nonnull String name, int arity, DBTermType dbBooleanType, DBTermType rootDBTermType, boolean doOrderingMatter) {
        super(name, AbstractDBIfThenFunctionSymbol.computeBaseTypes(arity, dbBooleanType, rootDBTermType));
        this.doOrderingMatter = doOrderingMatter;
    }

    private static ImmutableList<TermType> computeBaseTypes(int arity, DBTermType dbBooleanType, DBTermType rootDBTermType) {
        Stream<DBTermType> regularConditions = IntStream.range(0, arity - arity % 2).boxed().map(i -> i % 2 == 0 ? dbBooleanType : rootDBTermType);
        Stream<DBTermType> typeStream = arity % 2 == 0 ? regularConditions : Stream.concat(regularConditions, Stream.of(rootDBTermType));
        return (ImmutableList)typeStream.collect(ImmutableCollectors.toList());
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Stream<ImmutableTerm> extractPossibleValues(ImmutableList<? extends ImmutableTerm> terms) {
        return IntStream.range(1, terms.size()).filter(i -> i % 2 == 1).boxed().map(arg_0 -> terms.get(arg_0));
    }

    @Override
    public ImmutableTerm simplify(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        int arity = this.getArity();
        ArrayList<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> newWhenPairs = new ArrayList<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>>();
        for (int i = 0; i < arity - arity % 2; i += 2) {
            ImmutableTerm term = (ImmutableTerm)terms.get(i);
            ImmutableExpression expression = Optional.of(term).filter(t -> t instanceof ImmutableExpression).map(t -> (ImmutableExpression)t).orElseThrow(() -> new MinorOntopInternalBugException(term + " was expected to be an ImmutableExpression due to its position in " + this));
            ImmutableExpression.Evaluation evaluation = expression.evaluate2VL(variableNullability);
            if (evaluation.getValue().isPresent()) {
                switch (evaluation.getValue().get()) {
                    case TRUE: {
                        ImmutableTerm possibleValue = this.simplifyValue((ImmutableTerm)terms.get(i + 1), variableNullability, termFactory);
                        if (newWhenPairs.isEmpty()) {
                            return possibleValue;
                        }
                        return termFactory.getDBCase(newWhenPairs.stream(), possibleValue, this.doOrderingMatter).simplify(variableNullability);
                    }
                }
                continue;
            }
            ImmutableExpression newExpression = evaluation.getExpression().orElseThrow(() -> new MinorOntopInternalBugException("The evaluation was expected to return an expression because no value was returned"));
            ImmutableTerm possibleValue = this.simplifyValue((ImmutableTerm)terms.get(i + 1), variableNullability, termFactory);
            newWhenPairs.add(Maps.immutableEntry((Object)newExpression, (Object)possibleValue));
        }
        ImmutableTerm defaultValue = this.simplifyValue(this.extractDefaultValue(terms, termFactory), variableNullability, termFactory);
        Optional<ImmutableFunctionalTerm> optionalLiftedOptionalTerm = this.tryToLiftRDFTermTypeFunctions(newWhenPairs, defaultValue, termFactory);
        if (optionalLiftedOptionalTerm.isPresent()) {
            return optionalLiftedOptionalTerm.get().simplify(variableNullability);
        }
        ImmutableList<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> shrunkWhenPairs = this.shrinkWhenPairs(newWhenPairs, defaultValue);
        if (shrunkWhenPairs.isEmpty()) {
            return defaultValue;
        }
        ImmutableFunctionalTerm newTerm = this.buildCase(shrunkWhenPairs.stream(), defaultValue, termFactory);
        return shrunkWhenPairs.size() < terms.size() % 2 ? newTerm.simplify(variableNullability) : newTerm;
    }

    protected ImmutableTerm simplifyValue(ImmutableTerm immutableTerm, VariableNullability variableNullability, TermFactory termFactory) {
        return immutableTerm.simplify(variableNullability);
    }

    private Optional<ImmutableFunctionalTerm> tryToLiftRDFTermTypeFunctions(List<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> whenPairs, ImmutableTerm defaultValue, TermFactory termFactory) {
        ImmutableList possibleTerms = (ImmutableList)Stream.concat(whenPairs.stream().map(Map.Entry::getValue), Stream.of(defaultValue)).collect(ImmutableCollectors.toList());
        if (possibleTerms.stream().allMatch(t -> t instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)t).getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol)) {
            Stream<Map.Entry> newWhenPairs = whenPairs.stream().map(e -> Maps.immutableEntry(e.getKey(), (Object)((ImmutableFunctionalTerm)e.getValue()).getTerm(0)));
            ImmutableTerm newDefaultValue = ((ImmutableFunctionalTerm)defaultValue).getTerm(0);
            ImmutableFunctionalTerm newCase = termFactory.getDBCase(newWhenPairs, newDefaultValue, this.doOrderingMatter);
            ImmutableSet functionSymbols = (ImmutableSet)possibleTerms.stream().map(t -> (ImmutableFunctionalTerm)t).map(t -> (RDFTermTypeFunctionSymbol)t.getFunctionSymbol()).collect(ImmutableCollectors.toSet());
            ImmutableSet dictionaries = (ImmutableSet)functionSymbols.stream().map(RDFTermTypeFunctionSymbol::getDictionary).collect(ImmutableCollectors.toSet());
            if (dictionaries.size() != 1) {
                throw new MinorOntopInternalBugException("All the RDFTermTypeFunctionSymbol were expected to use the same dictionary");
            }
            TypeConstantDictionary dictionary = (TypeConstantDictionary)dictionaries.stream().findAny().get();
            ImmutableSet possibleConstants = (ImmutableSet)functionSymbols.stream().flatMap(f -> f.getConversionMap().values().stream()).collect(ImmutableCollectors.toSet());
            return Optional.of(termFactory.getRDFTermTypeFunctionalTerm(newCase, dictionary, (ImmutableSet<RDFTermTypeConstant>)possibleConstants, false));
        }
        return Optional.empty();
    }

    protected ImmutableFunctionalTerm buildCase(Stream<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> newWhenPairs, ImmutableTerm defaultValue, TermFactory termFactory) {
        return termFactory.getDBCase(newWhenPairs, defaultValue, this.doOrderingMatter);
    }

    private ImmutableList<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> shrinkWhenPairs(List<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> newWhenPairs, ImmutableTerm defaultValue) {
        return this.doOrderingMatter ? this.shrinkWhenPairsWithOrder(newWhenPairs, defaultValue) : this.shrinkWhenPairsWithoutOrder(newWhenPairs, defaultValue);
    }

    private ImmutableList<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> shrinkWhenPairsWithOrder(List<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> whenPairs, ImmutableTerm defaultValue) {
        int nbPairs = whenPairs.size();
        Optional<Integer> lastIncompatibleIndex = IntStream.range(0, nbPairs).map(i -> nbPairs - i - 1).filter(i -> !((ImmutableTerm)((Map.Entry)whenPairs.get(i)).getValue()).equals(defaultValue)).boxed().findFirst();
        return lastIncompatibleIndex.map(i -> ImmutableList.copyOf(whenPairs.subList(0, i + 1))).orElseGet(ImmutableList::of);
    }

    private ImmutableList<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> shrinkWhenPairsWithoutOrder(List<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> whenPairs, ImmutableTerm defaultValue) {
        return (ImmutableList)whenPairs.stream().filter(p -> !((ImmutableTerm)p.getValue()).equals(defaultValue)).collect(ImmutableCollectors.toList());
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return this.extractSubFunctionalTerms(arguments).allMatch(ImmutableFunctionalTerm::canBePostProcessed);
    }

    protected Stream<ImmutableFunctionalTerm> extractSubFunctionalTerms(ImmutableList<? extends ImmutableTerm> subTerms) {
        return subTerms.stream().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).flatMap(f -> Stream.concat(Stream.of(f), this.extractSubFunctionalTerms(f.getTerms())));
    }

    protected abstract ImmutableTerm extractDefaultValue(ImmutableList<? extends ImmutableTerm> var1, TermFactory var2);

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return false;
    }

    @Override
    protected ImmutableList<? extends ImmutableTerm> transformIntoRegularArguments(ImmutableList<? extends NonFunctionalTerm> arguments, TermFactory termFactory) {
        return (ImmutableList)IntStream.range(0, arguments.size()).boxed().map(i -> i % 2 == 0 ? termFactory.getIsTrue((NonFunctionalTerm)arguments.get(i.intValue())) : (ImmutableTerm)arguments.get(i.intValue())).collect(ImmutableCollectors.toList());
    }

    @Override
    public ImmutableExpression pushDownExpression(ImmutableExpression expression, int indexOfDBIfThenFunctionSymbol, TermFactory termFactory) {
        return this.pushDownFunctionalTerm(expression, indexOfDBIfThenFunctionSymbol, termFactory, (f, terms) -> termFactory.getImmutableExpression((BooleanFunctionSymbol)f, (ImmutableList<? extends ImmutableTerm>)terms), (pairs, defaultValue) -> termFactory.getDBBooleanCase((Stream<Map.Entry<ImmutableExpression, ImmutableExpression>>)pairs, (ImmutableExpression)defaultValue, this.doOrderingMatter));
    }

    @Override
    public ImmutableFunctionalTerm pushDownRegularFunctionalTerm(ImmutableFunctionalTerm functionalTerm, int indexOfDBIfThenFunctionSymbol, TermFactory termFactory) {
        return this.pushDownFunctionalTerm(functionalTerm, indexOfDBIfThenFunctionSymbol, termFactory, termFactory::getImmutableFunctionalTerm, (pairs, defaultValue) -> termFactory.getDBCase((Stream<? extends Map.Entry<ImmutableExpression, ? extends ImmutableTerm>>)pairs, (ImmutableTerm)defaultValue, this.doOrderingMatter));
    }

    protected <T extends ImmutableFunctionalTerm> T pushDownFunctionalTerm(T functionalTerm, int indexOfDBIfThenFunctionSymbol, TermFactory termFactory, BiFunction<FunctionSymbol, ImmutableList<? extends ImmutableTerm>, T> functionalTermCst, BiFunction<Stream<Map.Entry<ImmutableExpression, T>>, T, T> caseCst) {
        ImmutableList<? extends ImmutableTerm> expressionArguments = functionalTerm.getTerms();
        if (indexOfDBIfThenFunctionSymbol >= expressionArguments.size()) {
            throw new IllegalArgumentException("Wrong index given");
        }
        ImmutableList ifThenArguments = Optional.of(expressionArguments.get(indexOfDBIfThenFunctionSymbol)).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> this.equals(t.getFunctionSymbol())).map(ImmutableFunctionalTerm::getTerms).orElseThrow(() -> new IllegalArgumentException("Was expected to find this function symbol at the indicated position"));
        FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
        Stream<Map.Entry> whenPairs = IntStream.range(0, ifThenArguments.size() / 2).boxed().map(i -> Maps.immutableEntry((Object)((ImmutableExpression)ifThenArguments.get(2 * i)), functionalTermCst.apply(functionSymbol, this.updateArguments((ImmutableTerm)ifThenArguments.get(2 * i + 1), indexOfDBIfThenFunctionSymbol, expressionArguments))));
        ImmutableFunctionalTerm defaultValue = (ImmutableFunctionalTerm)functionalTermCst.apply(functionSymbol, this.updateArguments(this.extractDefaultValue((ImmutableList<? extends ImmutableTerm>)ifThenArguments, termFactory), indexOfDBIfThenFunctionSymbol, expressionArguments));
        return (T)((ImmutableFunctionalTerm)caseCst.apply((Stream<Map.Entry<ImmutableExpression, Stream<Map.Entry>>>)whenPairs, (Stream<Map.Entry>)((Object)defaultValue)));
    }

    private ImmutableList<? extends ImmutableTerm> updateArguments(ImmutableTerm subTerm, int index, ImmutableList<? extends ImmutableTerm> expressionArguments) {
        return (ImmutableList)IntStream.range(0, expressionArguments.size()).boxed().map(i -> i == index ? subTerm : (ImmutableTerm)expressionArguments.get(i.intValue())).collect(ImmutableCollectors.toList());
    }
}

