/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.validation.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.validation.IntermediateQueryValidator;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

@Singleton
public class StandardIntermediateQueryValidator
implements IntermediateQueryValidator {
    @Inject
    protected StandardIntermediateQueryValidator() {
    }

    protected ValidationVisitor createVisitor(IntermediateQuery query) {
        return new ValidationVisitor(query);
    }

    @Override
    public void validate(IntermediateQuery query) throws InvalidIntermediateQueryException {
        this.validateProjectedVariables(query);
        ValidationVisitor visitor = this.createVisitor(query);
        query.getNodesInTopDownOrder().forEach(n -> n.acceptVisitor(visitor));
    }

    private void validateProjectedVariables(IntermediateQuery query) throws InvalidIntermediateQueryException {
        ImmutableSet<Variable> projectedVariables = query.getVariables(query.getRootNode());
        if (!projectedVariables.equals(query.getProjectionAtom().getVariables())) {
            throw new InvalidIntermediateQueryException("The variables projected by the root node" + projectedVariables + " do not match the projection atom " + query.getProjectionAtom());
        }
    }

    protected static class ValidationVisitor
    implements QueryNodeVisitor {
        private final IntermediateQuery query;

        protected ValidationVisitor(IntermediateQuery query) {
            this.query = query;
        }

        protected IntermediateQuery getQuery() {
            return this.query;
        }

        @Override
        public void visit(ConstructionNode constructionNode) {
            if (this.query.getChildren(constructionNode).size() != 1) {
                throw new InvalidIntermediateQueryException("CONSTRUCTION node " + constructionNode + " must have ONE and ONLY ONE child.\n" + this.query);
            }
            ImmutableSet<Variable> requiredChildVariables = constructionNode.getChildVariables();
            for (QueryNode child : this.query.getChildren(constructionNode)) {
                ImmutableSet<Variable> childProjectedVariables = this.query.getVariables(child);
                if (childProjectedVariables.containsAll(requiredChildVariables)) continue;
                throw new InvalidIntermediateQueryException("This child " + child + " does not project all the variables required by the CONSTRUCTION node (" + requiredChildVariables + ")\n" + this.query);
            }
        }

        @Override
        public void visit(AggregationNode aggregationNode) {
        }

        @Override
        public void visit(UnionNode unionNode) {
            if (this.query.getChildren(unionNode).size() < 2) {
                throw new InvalidIntermediateQueryException("UNION node " + unionNode + " does not have at least 2 children node.");
            }
            ImmutableSet<Variable> unionProjectedVariables = unionNode.getVariables();
            for (QueryNode child : this.query.getChildren(unionNode)) {
                ImmutableSet<Variable> childProjectedVariables = this.query.getVariables(child);
                if (childProjectedVariables.containsAll(unionProjectedVariables)) continue;
                throw new InvalidIntermediateQueryException("This child " + child + " does not project all the variables required by the UNION node (" + unionProjectedVariables + ")\n" + this.query);
            }
        }

        @Override
        public void visit(InnerJoinNode innerJoinNode) {
            if (this.query.getChildren(innerJoinNode).size() < 2) {
                throw new InvalidIntermediateQueryException("JOIN node " + innerJoinNode + " does not have at least 2 children.\n" + this.query);
            }
            innerJoinNode.getOptionalFilterCondition().ifPresent(e -> this.checkExpression(innerJoinNode, (ImmutableExpression)e));
        }

        @Override
        public void visit(LeftJoinNode leftJoinNode) {
            if (this.query.getChildren(leftJoinNode).size() != 2) {
                throw new InvalidIntermediateQueryException("LEFTJOIN node " + leftJoinNode + " does not have 2 children.\n" + this.query);
            }
            leftJoinNode.getOptionalFilterCondition().ifPresent(e -> this.checkExpression(leftJoinNode, (ImmutableExpression)e));
        }

        @Override
        public void visit(FilterNode filterNode) {
            if (this.query.getChildren(filterNode).size() != 1) {
                throw new InvalidIntermediateQueryException("FILTER node " + filterNode + " does not have single child.\n" + this.query);
            }
            this.checkExpression(filterNode, filterNode.getFilterCondition());
        }

        private void checkExpression(JoinOrFilterNode node, ImmutableExpression expression) {
            ImmutableSet unboundVariables = (ImmutableSet)expression.getVariableStream().filter(v -> !((ImmutableSet)this.query.getChildren(node).stream().flatMap(c -> this.query.getVariables((QueryNode)c).stream()).collect(ImmutableCollectors.toSet())).contains(v)).collect(ImmutableCollectors.toSet());
            if (!unboundVariables.isEmpty()) {
                throw new InvalidIntermediateQueryException("Expression " + expression + " of " + expression + " uses unbound variables (" + unboundVariables + ").\n" + this.query);
            }
        }

        @Override
        public void visit(IntensionalDataNode intensionalDataNode) {
            if (this.query.getChildren(intensionalDataNode).size() != 0) {
                throw new InvalidIntermediateQueryException("DATA node " + intensionalDataNode + " has a child.\n" + this.query);
            }
        }

        @Override
        public void visit(ExtensionalDataNode extensionalDataNode) {
            if (this.query.getChildren(extensionalDataNode).size() != 0) {
                throw new InvalidIntermediateQueryException("DATA node " + extensionalDataNode + " has a child.\n" + this.query);
            }
        }

        @Override
        public void visit(EmptyNode emptyNode) {
            if (this.query.getChildren(emptyNode).size() != 0) {
                throw new InvalidIntermediateQueryException("EMPTY node " + emptyNode + " has a child.\n" + this.query);
            }
        }

        @Override
        public void visit(TrueNode trueNode) {
            if (this.query.getChildren(trueNode).size() != 0) {
                throw new InvalidIntermediateQueryException("TRUENODE node " + trueNode + " has a child.\n" + this.query);
            }
        }

        @Override
        public void visit(DistinctNode distinctNode) {
            if (this.query.getChildren(distinctNode).size() != 1) {
                throw new InvalidIntermediateQueryException("DISTINCT node " + distinctNode + " must have ONE and ONLY ONE child.\n" + this.query);
            }
        }

        @Override
        public void visit(SliceNode sliceNode) {
            if (this.query.getChildren(sliceNode).size() != 1) {
                throw new InvalidIntermediateQueryException("SLICE node " + sliceNode + " must have ONE and ONLY ONE child.\n" + this.query);
            }
        }

        @Override
        public void visit(OrderByNode orderByNode) {
            if (this.query.getChildren(orderByNode).size() != 1) {
                throw new InvalidIntermediateQueryException("ORDER BY node " + orderByNode + " must have ONE and ONLY ONE child.\n" + this.query);
            }
            ImmutableSet<Variable> requiredVariables = orderByNode.getLocallyRequiredVariables();
            for (QueryNode child : this.query.getChildren(orderByNode)) {
                if (this.query.getVariables(child).containsAll(requiredVariables)) continue;
                throw new InvalidIntermediateQueryException("Some variables used in the node " + this + " are not provided by its child " + child);
            }
        }
    }
}

