/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Set;

@Singleton
public class NotRequiredVariableRemoverImpl
implements NotRequiredVariableRemover {
    private final CoreSingletons coreSingletons;

    @Inject
    protected NotRequiredVariableRemoverImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQTree optimize(IQTree tree, ImmutableSet<Variable> requiredVariables, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> variables = tree.getVariables();
        if (variables.equals(requiredVariables)) {
            return tree;
        }
        ImmutableSet<Variable> notInternallyRequiredVariables = tree.getNotInternallyRequiredVariables();
        if (notInternallyRequiredVariables.isEmpty()) {
            return tree;
        }
        Sets.SetView variablesToRemove = Sets.intersection((Set)Sets.difference(variables, requiredVariables), notInternallyRequiredVariables);
        if (variablesToRemove.isEmpty()) {
            return tree;
        }
        return this.removeNonRequiredVariables(tree, (ImmutableSet<Variable>)variablesToRemove.immutableCopy(), variableGenerator);
    }

    protected IQTree removeNonRequiredVariables(IQTree tree, ImmutableSet<Variable> variablesToRemove, VariableGenerator variableGenerator) {
        return new VariableRemoverTransformer(variablesToRemove, variableGenerator, this.coreSingletons).transform(tree);
    }

    protected static class VariableRemoverTransformer
    implements IQTreeVisitingTransformer {
        protected final ImmutableSet<Variable> variablesToRemove;
        protected final IntermediateQueryFactory iqFactory;
        protected final SubstitutionFactory substitutionFactory;
        protected final CoreSingletons coreSingletons;
        protected final VariableGenerator variableGenerator;
        protected final ConstructionSubstitutionNormalizer substitutionNormalizer;

        public VariableRemoverTransformer(ImmutableSet<Variable> variablesToRemove, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
            this.variablesToRemove = variablesToRemove;
            this.variableGenerator = variableGenerator;
            this.iqFactory = coreSingletons.getIQFactory();
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.coreSingletons = coreSingletons;
            this.substitutionNormalizer = coreSingletons.getConstructionSubstitutionNormalizer();
        }

        protected IQTreeTransformer createNewTransformer(ImmutableSet<Variable> variablesToRemove) {
            return new VariableRemoverTransformer(variablesToRemove, this.variableGenerator, this.coreSingletons);
        }

        @Override
        public IQTree transformIntensionalData(IntensionalDataNode rootNode) {
            return rootNode;
        }

        @Override
        public IQTree transformExtensionalData(ExtensionalDataNode rootNode) {
            ImmutableMap newArgumentMap = rootNode.getArgumentMap().entrySet().stream().filter(e -> !this.variablesToRemove.contains(e.getValue())).collect(ImmutableCollectors.toMap());
            return this.iqFactory.createExtensionalDataNode(rootNode.getRelationDefinition(), newArgumentMap);
        }

        @Override
        public IQTree transformEmpty(EmptyNode rootNode) {
            return this.iqFactory.createEmptyNode((ImmutableSet<Variable>)Sets.difference(rootNode.getVariables(), this.variablesToRemove).immutableCopy());
        }

        @Override
        public IQTree transformTrue(TrueNode rootNode) {
            return rootNode;
        }

        @Override
        public IQTree transformNonStandardLeafNode(LeafIQTree rootNode) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }

        @Override
        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            ImmutableSet variablesToKeep = Sets.difference(tree.getVariables(), this.variablesToRemove).immutableCopy();
            ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = this.substitutionNormalizer.normalizeSubstitution(rootNode.getSubstitution(), (ImmutableSet<Variable>)variablesToKeep);
            ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)variablesToKeep, normalization.getNormalizedSubstitution());
            IQTree newChild = normalization.updateChild(child);
            return this.iqFactory.createUnaryIQTree(newConstructionNode, newChild).normalizeForOptimization(this.variableGenerator);
        }

        @Override
        public IQTree transformAggregation(IQTree tree, AggregationNode aggregationNode, IQTree child) {
            AggregationNode newAggregationNode = this.iqFactory.createAggregationNode(aggregationNode.getGroupingVariables(), this.substitutionFactory.getSubstitution(aggregationNode.getSubstitution().getImmutableMap().entrySet().stream().filter(e -> !this.variablesToRemove.contains(e.getKey())).collect(ImmutableCollectors.toMap())));
            return this.iqFactory.createUnaryIQTree(newAggregationNode, child).normalizeForOptimization(this.variableGenerator);
        }

        @Override
        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformSlice(IQTree tree, SliceNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformNonStandardUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }

        @Override
        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            return this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, this.transformNonUniqueChild(leftChild), this.transformNonUniqueChild(rightChild));
        }

        private IQTree transformNonUniqueChild(IQTree child) {
            Sets.SetView childVariablesToRemove = Sets.intersection(child.getVariables(), this.variablesToRemove);
            return childVariablesToRemove.isEmpty() ? child : (childVariablesToRemove.equals(this.variablesToRemove) ? this.transform(child) : this.createNewTransformer((ImmutableSet<Variable>)childVariablesToRemove.immutableCopy()).transform(child));
        }

        @Override
        public IQTree transformNonStandardBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }

        @Override
        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            return this.iqFactory.createNaryIQTree(rootNode, (ImmutableList<IQTree>)((ImmutableList)children.stream().map(this::transformNonUniqueChild).collect(ImmutableCollectors.toList())));
        }

        @Override
        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            UnionNode newUnionNode = this.iqFactory.createUnionNode((ImmutableSet<Variable>)Sets.difference(rootNode.getVariables(), this.variablesToRemove).immutableCopy());
            return this.iqFactory.createNaryIQTree(newUnionNode, children).normalizeForOptimization(this.variableGenerator);
        }

        @Override
        public IQTree transformNonStandardNaryNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }
    }
}

