/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class JoinOrFilterVariableNullabilityTools {
    private final TermNullabilityEvaluator nullabilityEvaluator;
    private final CoreUtilsFactory coreUtilsFactory;

    @Inject
    private JoinOrFilterVariableNullabilityTools(TermNullabilityEvaluator nullabilityEvaluator, CoreUtilsFactory coreUtilsFactory) {
        this.nullabilityEvaluator = nullabilityEvaluator;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    public VariableNullability getChildrenVariableNullability(ImmutableList<IQTree> children) {
        return this.getVariableNullability(children, Optional.empty());
    }

    public VariableNullability getVariableNullability(ImmutableList<IQTree> children, Optional<ImmutableExpression> joiningCondition) {
        ImmutableMap variableProvenanceMap = children.stream().flatMap(c -> c.getVariables().stream().map(v -> Maps.immutableEntry((Object)v, (Object)c))).collect(ImmutableCollectors.toMultimap()).asMap();
        ImmutableSet coOccuringVariables = (ImmutableSet)variableProvenanceMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        ImmutableSet nullableGroups = (ImmutableSet)children.stream().flatMap(c -> c.getVariableNullability().getNullableGroups().stream()).filter(g -> g.stream().noneMatch(arg_0 -> ((ImmutableSet)coOccuringVariables).contains(arg_0))).collect(ImmutableCollectors.toSet());
        ImmutableSet scope = (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
        return joiningCondition.map(e -> this.updateWithFilter((ImmutableExpression)e, (ImmutableSet<ImmutableSet<Variable>>)nullableGroups, (ImmutableSet<Variable>)scope)).orElseGet(() -> this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, (ImmutableSet<Variable>)scope));
    }

    public VariableNullability updateWithFilter(ImmutableExpression filter, ImmutableSet<ImmutableSet<Variable>> nullableGroups, ImmutableSet<Variable> scope) {
        ImmutableSet newNullableGroups = (ImmutableSet)nullableGroups.stream().filter(g -> !this.nullabilityEvaluator.isFilteringNullValues(filter, (ImmutableSet<Variable>)g)).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, scope);
    }

    public VariableNullability getDummyVariableNullability(ImmutableSet<Variable> variables) {
        return this.coreUtilsFactory.createDummyVariableNullability(variables.stream());
    }
}

