/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.DummyVariableNullability;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeTools;
import it.unibz.inf.ontop.model.term.GroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class ExtendedProjectionNodeImpl
extends CompositeQueryNodeImpl
implements ExtendedProjectionNode {
    private final ImmutableUnificationTools unificationTools;
    private final ConstructionNodeTools constructionNodeTools;
    private final ImmutableSubstitutionTools substitutionTools;
    private final TermFactory termFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    public ExtendedProjectionNodeImpl(SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, ImmutableUnificationTools unificationTools, ConstructionNodeTools constructionNodeTools, ImmutableSubstitutionTools substitutionTools, TermFactory termFactory, CoreUtilsFactory coreUtilsFactory) {
        super(substitutionFactory, iqFactory);
        this.unificationTools = unificationTools;
        this.constructionNodeTools = constructionNodeTools;
        this.substitutionTools = substitutionTools;
        this.termFactory = termFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child) {
        return this.applyDescendingSubstitution(descendingSubstitution, child, (IQTree c, ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm> r) -> this.propagateDescendingSubstitutionToChild(c, r, constraint));
    }

    private IQTree propagateDescendingSubstitutionToChild(IQTree child, ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm> tauFPropagationResults, Optional<ImmutableExpression> constraint) throws EmptyTreeException {
        DummyVariableNullability dummyVariableNullability = this.coreUtilsFactory.createDummyVariableNullability(child.getVariables().stream());
        Optional<ImmutableExpression> descendingConstraint = this.computeChildConstraint(tauFPropagationResults.theta, constraint, dummyVariableNullability);
        return Optional.of(tauFPropagationResults.delta).filter(delta -> !delta.isEmpty()).map(delta -> child.applyDescendingSubstitution((ImmutableSubstitution<? extends VariableOrGroundTerm>)delta, descendingConstraint)).orElse(child);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child) {
        return this.applyDescendingSubstitution(descendingSubstitution, child, (IQTree c, ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm> r) -> Optional.of(r.delta).filter(delta -> !delta.isEmpty()).map(c::applyDescendingSubstitutionWithoutOptimizing).orElse(c));
    }

    private IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> tau, IQTree child, DescendingSubstitutionChildUpdateFunction updateChildFct) {
        ImmutableSet<Variable> newProjectedVariables = this.constructionNodeTools.computeNewProjectedVariables(tau, this.getVariables());
        ImmutableSubstitution<NonFunctionalTerm> tauC = tau.getNonFunctionalTermFragment();
        ImmutableSubstitution<GroundFunctionalTerm> tauF = tau.getGroundFunctionalTermFragment();
        try {
            ConstructionNodeImpl.PropagationResults<NonFunctionalTerm> tauCPropagationResults = this.propagateTauC(tauC, child);
            ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm> tauFPropagationResults = this.propagateTauF(tauF, tauCPropagationResults);
            Optional<FilterNode> filterNode = tauFPropagationResults.filter.map(this.iqFactory::createFilterNode);
            IQTree newChild = updateChildFct.apply(child, tauFPropagationResults);
            Optional<ExtendedProjectionNode> projectionNode = this.computeNewProjectionNode(newProjectedVariables, tauFPropagationResults.theta, newChild);
            IQTree filterTree = filterNode.map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, newChild)).orElse(newChild);
            return projectionNode.map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, filterTree)).orElse(filterTree);
        }
        catch (EmptyTreeException e) {
            return this.iqFactory.createEmptyNode(newProjectedVariables);
        }
    }

    protected abstract Optional<ExtendedProjectionNode> computeNewProjectionNode(ImmutableSet<Variable> var1, ImmutableSubstitution<ImmutableTerm> var2, IQTree var3);

    private ConstructionNodeImpl.PropagationResults<NonFunctionalTerm> propagateTauC(ImmutableSubstitution<NonFunctionalTerm> tauC, IQTree child) throws EmptyTreeException {
        ImmutableSet<Variable> projectedVariables = this.getVariables();
        ImmutableSubstitution<? extends ImmutableTerm> substitution = this.getSubstitution();
        ImmutableSubstitution<NonFunctionalTerm> thetaC = substitution.getNonFunctionalTermFragment();
        ImmutableSet<Variable> vC = this.constructionNodeTools.computeNewProjectedVariables(tauC, projectedVariables);
        ImmutableSubstitution newEta = this.unificationTools.computeMGUS2(thetaC, tauC).map(eta -> this.substitutionTools.prioritizeRenaming(eta, vC)).orElseThrow(() -> new EmptyTreeException());
        ImmutableSubstitution<NonFunctionalTerm> thetaCBar = this.substitutionFactory.getSubstitution(newEta.getImmutableMap().entrySet().stream().filter(e -> vC.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
        ImmutableSubstitution<NonFunctionalTerm> deltaC = this.extractDescendingSubstitution(newEta, v -> v, thetaC, thetaCBar, projectedVariables);
        ImmutableSubstitution<ImmutableFunctionalTerm> thetaF = substitution.getFunctionalTermFragment();
        ImmutableMultimap<ImmutableTerm, ImmutableFunctionalTerm> m = thetaF.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMultimap(e -> deltaC.apply((ImmutableTerm)e.getKey()), e -> deltaC.applyToFunctionalTerm((ImmutableFunctionalTerm)e.getValue())));
        ImmutableSubstitution<ImmutableFunctionalTerm> thetaFBar = this.substitutionFactory.getSubstitution(m.asMap().entrySet().stream().filter(e -> e.getKey() instanceof Variable).filter(e -> !child.getVariables().contains(e.getKey())).collect(ImmutableCollectors.toMap(e -> (Variable)e.getKey(), e -> (ImmutableFunctionalTerm)((Collection)e.getValue()).iterator().next())));
        ImmutableSubstitution<ImmutableTerm> gamma = this.extractDescendingSubstitution(deltaC, thetaFBar::apply, thetaF, thetaFBar, projectedVariables);
        ImmutableSubstitution<NonFunctionalTerm> newDeltaC = gamma.getNonFunctionalTermFragment();
        Optional<ImmutableExpression> f = this.computeF(m, thetaFBar, gamma, newDeltaC);
        return new ConstructionNodeImpl.PropagationResults<NonFunctionalTerm>(thetaCBar, thetaFBar, newDeltaC, f);
    }

    private Optional<ImmutableExpression> computeF(ImmutableMultimap<ImmutableTerm, ImmutableFunctionalTerm> m, ImmutableSubstitution<ImmutableFunctionalTerm> thetaFBar, ImmutableSubstitution<ImmutableTerm> gamma, ImmutableSubstitution<NonFunctionalTerm> newDeltaC) {
        ImmutableSet thetaFBarEntries = thetaFBar.getImmutableMap().entrySet();
        Stream<ImmutableExpression> thetaFRelatedExpressions = m.entries().stream().filter(e -> !thetaFBarEntries.contains(e)).map(e -> this.termFactory.getStrictEquality(thetaFBar.apply((ImmutableTerm)e.getKey()), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
        Stream<ImmutableExpression> blockedExpressions = gamma.getImmutableMap().entrySet().stream().filter(e -> !newDeltaC.isDefining((Variable)e.getKey())).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
        return this.termFactory.getConjunction(Stream.concat(thetaFRelatedExpressions, blockedExpressions));
    }

    private ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm> propagateTauF(ImmutableSubstitution<GroundFunctionalTerm> tauF, ConstructionNodeImpl.PropagationResults<NonFunctionalTerm> tauCPropagationResults) {
        ImmutableSubstitution<ImmutableTerm> thetaBar = tauCPropagationResults.theta;
        ImmutableSubstitution<VariableOrGroundTerm> delta = this.substitutionFactory.getSubstitution(tauF.getImmutableMap().entrySet().stream().filter(e -> !thetaBar.isDefining((Variable)e.getKey())).filter(e -> !tauCPropagationResults.delta.isDefining((Variable)e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (VariableOrGroundTerm)e.getValue()))).composeWith2(tauCPropagationResults.delta);
        ImmutableSubstitution<ImmutableTerm> newTheta = this.substitutionFactory.getSubstitution(thetaBar.getImmutableMap().entrySet().stream().filter(e -> !tauF.isDefining((Variable)e.getKey())).collect(ImmutableCollectors.toMap()));
        Stream<ImmutableExpression> newConditionStream = Stream.concat(tauF.getImmutableMap().entrySet().stream().filter(e -> thetaBar.isDefining((Variable)e.getKey())).map(e -> this.termFactory.getStrictEquality(thetaBar.apply((ImmutableTerm)e.getKey()), tauF.apply((ImmutableTerm)e.getValue()), new ImmutableTerm[0])), tauF.getImmutableMap().entrySet().stream().filter(e -> tauCPropagationResults.delta.isDefining((Variable)e.getKey())).map(e -> this.termFactory.getStrictEquality(tauCPropagationResults.delta.apply((ImmutableTerm)e.getKey()), tauF.apply((ImmutableTerm)e.getValue()), new ImmutableTerm[0])));
        Optional<ImmutableExpression> newF = this.termFactory.getConjunction(Stream.concat(tauCPropagationResults.filter.map(ImmutableExpression::flattenAND).orElseGet(Stream::empty), newConditionStream));
        return new ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm>(newTheta, delta, newF);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child) {
        try {
            Optional<ImmutableExpression> childConstraint = this.computeChildConstraint(this.getSubstitution(), Optional.of(constraint), child.getVariableNullability());
            IQTree newChild = childConstraint.map(child::propagateDownConstraint).orElse(child);
            return this.iqFactory.createUnaryIQTree(this, newChild);
        }
        catch (EmptyTreeException e) {
            return this.iqFactory.createEmptyNode(this.getVariables());
        }
    }

    private Optional<ImmutableExpression> computeChildConstraint(ImmutableSubstitution<? extends ImmutableTerm> theta, Optional<ImmutableExpression> initialConstraint, VariableNullability childVariableNullability) throws EmptyTreeException {
        Optional<ImmutableExpression.Evaluation> descendingConstraintResults = initialConstraint.map(theta::applyToBooleanExpression).map(exp -> exp.evaluate(childVariableNullability));
        if (descendingConstraintResults.filter(ImmutableExpression.Evaluation::isEffectiveFalse).isPresent()) {
            throw new EmptyTreeException();
        }
        return descendingConstraintResults.flatMap(ImmutableExpression.Evaluation::getExpression);
    }

    private <T extends ImmutableTerm> ImmutableSubstitution<T> extractDescendingSubstitution(ImmutableSubstitution<? extends NonFunctionalTerm> substitution, Function<NonFunctionalTerm, T> valueTransformationFct, ImmutableSubstitution<? extends ImmutableTerm> partialTheta, ImmutableSubstitution<? extends ImmutableTerm> newPartialTheta, ImmutableSet<Variable> originalProjectedVariables) {
        return this.substitutionFactory.getSubstitution(substitution.getImmutableMap().entrySet().stream().filter(e -> {
            Variable v = (Variable)e.getKey();
            return !partialTheta.isDefining(v) && (!newPartialTheta.isDefining(v) || originalProjectedVariables.contains((Object)v));
        }).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableTerm)valueTransformationFct.apply((NonFunctionalTerm)e.getValue()))));
    }

    @Override
    public VariableNullability getVariableNullability(IQTree child) {
        return child.getVariableNullability().update(this.getSubstitution(), this.getVariables());
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree child) {
        return this.getSubstitution().isDefining(variable) || this.getChildVariables().contains((Object)variable) && child.isConstructed(variable);
    }

    protected class EmptyTreeException
    extends Exception {
        protected EmptyTreeException() {
        }
    }

    @FunctionalInterface
    protected static interface DescendingSubstitutionChildUpdateFunction {
        public IQTree apply(IQTree var1, ConstructionNodeImpl.PropagationResults<VariableOrGroundTerm> var2) throws EmptyTreeException;
    }
}

