/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.exception.QueryNodeSubstitutionException;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.stream.Stream;

@Singleton
public class ConstructionNodeTools {
    private final SubstitutionFactory substitutionFactory;
    private final ImmutableUnificationTools unificationTools;
    private final ImmutableSubstitutionTools substitutionTools;

    @Inject
    private ConstructionNodeTools(SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools) {
        this.substitutionFactory = substitutionFactory;
        this.unificationTools = unificationTools;
        this.substitutionTools = substitutionTools;
    }

    public ImmutableSet<Variable> computeNewProjectedVariables(ImmutableSubstitution<? extends ImmutableTerm> descendingSubstitution, ImmutableSet<Variable> projectedVariables) {
        ImmutableSet<Variable> tauDomain = descendingSubstitution.getDomain();
        Stream<Variable> remainingVariableStream = projectedVariables.stream().filter(v -> !tauDomain.contains(v));
        Stream newVariableStream = descendingSubstitution.getImmutableMap().entrySet().stream().filter(e -> projectedVariables.contains(e.getKey())).map(Map.Entry::getValue).flatMap(ImmutableTerm::getVariableStream);
        return (ImmutableSet)Stream.concat(newVariableStream, remainingVariableStream).collect(ImmutableCollectors.toSet());
    }

    public NewSubstitutionPair traverseConstructionNode(ImmutableSubstitution<? extends ImmutableTerm> tau, ImmutableSubstitution<? extends ImmutableTerm> formerTheta, ImmutableSet<Variable> formerV, ImmutableSet<Variable> newV) throws QueryNodeSubstitutionException {
        ImmutableSubstitution<ImmutableTerm> eta = this.unificationTools.computeMGUS(formerTheta, tau).orElseThrow(() -> new QueryNodeSubstitutionException("The descending substitution " + tau + " is incompatible with " + formerTheta));
        ImmutableSubstitution<? extends ImmutableTerm> normalizedEta = this.normalizeEta(eta, newV);
        ImmutableSubstitution<ImmutableTerm> newTheta = this.extractNewTheta(normalizedEta, newV);
        ImmutableSubstitution<? extends ImmutableTerm> delta = this.computeDelta(formerTheta, newTheta, normalizedEta, formerV);
        return new NewSubstitutionPair(newTheta, delta);
    }

    private ImmutableSubstitution<? extends ImmutableTerm> normalizeEta(ImmutableSubstitution<ImmutableTerm> eta, ImmutableSet<Variable> newV) {
        return this.substitutionTools.prioritizeRenaming(eta, newV);
    }

    private ImmutableSubstitution<ImmutableTerm> extractNewTheta(ImmutableSubstitution<? extends ImmutableTerm> normalizedEta, ImmutableSet<Variable> newV) {
        ImmutableMap<Variable, ImmutableTerm> newMap = normalizedEta.getImmutableMap().entrySet().stream().filter(e -> newV.contains(e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    private ImmutableSubstitution<? extends ImmutableTerm> computeDelta(ImmutableSubstitution<? extends ImmutableTerm> formerTheta, ImmutableSubstitution<? extends ImmutableTerm> newTheta, ImmutableSubstitution<? extends ImmutableTerm> eta, ImmutableSet<Variable> formerV) {
        ImmutableMap<Variable, ImmutableTerm> newMap = eta.getImmutableMap().entrySet().stream().filter(e -> !formerTheta.isDefining((Variable)e.getKey())).filter(e -> !newTheta.isDefining((Variable)e.getKey()) || formerV.contains(e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    public static class NewSubstitutionPair {
        public final ImmutableSubstitution<ImmutableTerm> bindings;
        public final ImmutableSubstitution<? extends ImmutableTerm> propagatedSubstitution;

        private NewSubstitutionPair(ImmutableSubstitution<ImmutableTerm> bindings, ImmutableSubstitution<? extends ImmutableTerm> propagatedSubstitution) {
            this.bindings = bindings;
            this.propagatedSubstitution = propagatedSubstitution;
        }
    }
}

