/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.equivalence;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.node.QueryNode;
import java.util.LinkedList;

public class IQSyntacticEquivalenceChecker {
    public static boolean areEquivalent(IntermediateQuery query1, IntermediateQuery query2) {
        if (!query1.getProjectionAtom().equals(query2.getProjectionAtom())) {
            return false;
        }
        LinkedList<NodePair> pairsToVisit = new LinkedList<NodePair>();
        pairsToVisit.add(new NodePair(query1.getRootNode(), query2.getRootNode()));
        while (!pairsToVisit.isEmpty()) {
            NodePair pair = (NodePair)pairsToVisit.poll();
            if (!IQSyntacticEquivalenceChecker.areNodesEqual(pair.node1, pair.node2)) {
                return false;
            }
            ImmutableList<QueryNode> children1 = IQSyntacticEquivalenceChecker.sort(query1.getChildren(pair.node1));
            ImmutableList<QueryNode> children2 = IQSyntacticEquivalenceChecker.sort(query2.getChildren(pair.node2));
            if (children1.size() != children2.size()) {
                return false;
            }
            for (int i = 0; i < children1.size(); ++i) {
                pairsToVisit.add(new NodePair((QueryNode)children1.get(i), (QueryNode)children2.get(i)));
            }
        }
        return true;
    }

    private static ImmutableList<QueryNode> sort(ImmutableList<QueryNode> children) {
        return children;
    }

    private static boolean areNodesEqual(QueryNode node1, QueryNode node2) {
        return node1.isSyntacticallyEquivalentTo(node2);
    }

    private static class NodePair {
        public final QueryNode node1;
        public final QueryNode node2;

        private NodePair(QueryNode node1, QueryNode node2) {
            this.node1 = node1;
            this.node2 = node2;
        }
    }
}

