/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import java.util.List;

public abstract class OntopAbstractModule
extends AbstractModule {
    private final OntopModelSettings settings;

    protected OntopAbstractModule(OntopModelSettings settings) {
        this.settings = settings;
    }

    public Class getImplementation(String interfaceClassName) throws UnknownClassException {
        String implementationClassName = this.settings.getProperty(interfaceClassName).orElseThrow(() -> new UnknownClassException(String.format("No entry for the interface %s in the settings.", interfaceClassName)));
        try {
            return Class.forName(implementationClassName);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownClassException(e.getMessage());
        }
    }

    public Class getImplementation(Class abstractInterface) throws UnknownClassException {
        return this.getImplementation(abstractInterface.getCanonicalName());
    }

    protected Module buildFactory(List<Class> types, Class factoryInterface) {
        FactoryModuleBuilder builder = new FactoryModuleBuilder();
        for (Class type : types) {
            builder = builder.implement(type, this.getImplementation(type.getCanonicalName()));
        }
        return builder.build(factoryInterface);
    }

    protected void configureCoreConfiguration() {
        this.bind(OntopModelSettings.class).toInstance((Object)this.settings);
    }

    protected OntopModelSettings getSettings() {
        return this.settings;
    }

    protected void bindFromSettings(Class abstractClass) {
        this.bind(abstractClass).to(this.getImplementation(abstractClass.getCanonicalName()));
    }

    public class UnknownClassException
    extends RuntimeException {
        public UnknownClassException(String message) {
            super(message);
        }
    }
}

